/*
 * Decompiled with CFR 0.152.
 */
package org.spout.nbt;

import java.util.Arrays;
import org.spout.nbt.Tag;
import org.spout.nbt.TagType;

public class IntArrayTag
extends Tag<int[]> {
    private final int[] value;

    public IntArrayTag(String name, int[] value) {
        super(TagType.TAG_INT_ARRAY, name);
        this.value = value;
    }

    @Override
    public int[] getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder hex = new StringBuilder();
        int[] nArray = this.value;
        int n = this.value.length;
        int n2 = 0;
        while (n2 < n) {
            int s = nArray[n2];
            String hexDigits = Integer.toHexString(s).toUpperCase();
            if (hexDigits.length() == 1) {
                hex.append("0");
            }
            hex.append(hexDigits).append(" ");
            ++n2;
        }
        String name = this.getName();
        String append = "";
        if (name != null && !name.equals("")) {
            append = "(\"" + this.getName() + "\")";
        }
        return "TAG_Short_Array" + append + ": " + hex.toString();
    }

    @Override
    public IntArrayTag clone() {
        int[] clonedArray = this.cloneArray(this.value);
        return new IntArrayTag(this.getName(), clonedArray);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof IntArrayTag)) {
            return false;
        }
        IntArrayTag tag = (IntArrayTag)other;
        return Arrays.equals(this.value, tag.value) && this.getName().equals(tag.getName());
    }

    private int[] cloneArray(int[] intArray) {
        if (intArray == null) {
            return null;
        }
        int length = intArray.length;
        byte[] newArray = new byte[length];
        System.arraycopy(intArray, 0, newArray, 0, length);
        return intArray;
    }
}

