/*
 * Decompiled with CFR 0.152.
 */
package argo.staj;

import argo.staj.JsonStreamElement;
import argo.staj.JsonStreamElementType;
import argo.staj.PositionTrackingPushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StajParser
implements Iterator<JsonStreamElement> {
    private final PositionTrackingPushbackReader pushbackReader;
    private final Stack<JsonStreamElementType> stack = new Stack();
    private JsonStreamElement current;
    private JsonStreamElement next;

    public StajParser(Reader in) {
        this.pushbackReader = new PositionTrackingPushbackReader(in);
    }

    public StajParser(String json) {
        this.pushbackReader = new PositionTrackingPushbackReader(new StringReader(json));
    }

    @Override
    public boolean hasNext() {
        if (this.current != null && this.current.jsonStreamElementType().equals((Object)JsonStreamElementType.END_DOCUMENT)) {
            return false;
        }
        if (this.next == null) {
            this.next = this.getNextElement();
        }
        return true;
    }

    @Override
    public JsonStreamElement next() {
        if (this.next != null) {
            this.current = this.next;
            this.next = null;
        } else {
            this.current = this.getNextElement();
        }
        return this.current;
    }

    private JsonStreamElement getNextElement() {
        if (this.current != null) {
            return this.current.jsonStreamElementType().parseNext(this.pushbackReader, this.stack);
        }
        return JsonStreamElementType.parseFirstElement(this.pushbackReader);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("StajParser cannot remove elements from JSON it has parsed.");
    }
}

