/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.Start;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Scanner;

public class OP {
    private static FileOutputStream fileOutputStream;
    private static FileInputStream fileInputStream;

    public static final boolean del(File dir) {
        if (dir.exists()) {
            File f = dir;
            if (f.isDirectory()) {
                File[] files;
                File[] fileArray = files = f.listFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    OP.del(file);
                    ++n2;
                }
            }
            return f.delete();
        }
        return false;
    }

    public static final boolean del(String dir) {
        return OP.del(new File(dir));
    }

    public static final void copy(File source, File target) throws FileNotFoundException, IOException {
        if (source.exists()) {
            if (source.isDirectory()) {
                OP.makedirs(target);
                OP.copyDir(source, target);
            } else {
                OP.makedirs(target.getParentFile());
                OP.copyFile(source, target);
            }
        }
    }

    public static final void copyFile(File source, File target) throws IOException {
        if (source.exists()) {
            if (!target.exists()) {
                target.createNewFile();
            }
            AbstractInterruptibleChannel sourceChannel = null;
            AbstractInterruptibleChannel targetChannel = null;
            try {
                fileInputStream = new FileInputStream(source);
                sourceChannel = fileInputStream.getChannel();
                fileOutputStream = new FileOutputStream(target);
                targetChannel = fileOutputStream.getChannel();
                ((FileChannel)targetChannel).transferFrom((ReadableByteChannel)((Object)sourceChannel), 0L, ((FileChannel)sourceChannel).size());
            }
            finally {
                if (sourceChannel != null) {
                    sourceChannel.close();
                }
                if (targetChannel != null) {
                    targetChannel.close();
                }
            }
        }
    }

    public static final void copyDir(File source, File target) throws FileNotFoundException, IOException {
        if (source.exists()) {
            File[] files = source.listFiles();
            target.mkdirs();
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    OP.copyDir(file, new File(String.valueOf(target.getAbsolutePath()) + System.getProperty("file.separator") + file.getName()));
                } else {
                    OP.copyFile(file, new File(String.valueOf(target.getAbsolutePath()) + System.getProperty("file.separator") + file.getName()));
                }
                ++n2;
            }
        }
    }

    public static final void rename(File oldFile, File newFile) throws FileNotFoundException, IOException {
        oldFile.renameTo(newFile);
    }

    public static final void makedirs(File folder) {
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    public static final void Textwriters(File file, String line, boolean append) throws IOException {
        String[] lines = new String[]{line};
        OP.Textwriter(file, lines, append);
    }

    public static final void Textwriter(File file, String[] lines, boolean append) throws IOException {
        boolean newLine = false;
        if (file.length() != 0L && append) {
            newLine = true;
        }
        FileWriter fr = null;
        BufferedWriter bw = null;
        try {
            fr = new FileWriter(file.toString(), append);
            bw = new BufferedWriter(fr);
            int i = 0;
            while (i < lines.length) {
                if (newLine) {
                    bw.newLine();
                }
                bw.write(lines[i]);
                if (i < lines.length - 1) {
                    bw.newLine();
                }
                ++i;
            }
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            if (fr != null) {
                fr.close();
            }
        }
    }

    public static final String[] Textreader(File file) throws IOException {
        ArrayList<String> text = new ArrayList<String>();
        FileReader fr = null;
        BufferedReader br = null;
        try {
            String line;
            fr = new FileReader(file);
            br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                text.add(line);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (fr != null) {
                fr.close();
            }
        }
        return text.toArray(new String[text.size()]);
    }

    public static final String[] Textreader(File file, String charset) throws IOException {
        ArrayList<String> arrayStr = new ArrayList<String>();
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String line;
            fis = new FileInputStream(file);
            isr = new InputStreamReader((InputStream)fis, charset);
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                arrayStr.add(line);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return arrayStr.toArray(new String[arrayStr.size()]);
    }

    public static final String Textreaders(File file) throws IOException {
        String[] StrArr = OP.Textreader(file);
        String inh = "";
        int i = 0;
        while (i < StrArr.length) {
            inh = String.valueOf(inh) + StrArr[i];
            ++i;
        }
        return inh;
    }

    public static final ArrayList<String> Textreadera(File datei) throws IOException {
        String line = "";
        ArrayList<String> list = new ArrayList<String>();
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            fis = new FileInputStream(datei);
            isr = new InputStreamReader(fis);
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return list;
    }

    public static final ArrayList<String> Textreadera(File datei, String charset) throws IOException {
        String line = "";
        ArrayList<String> list = new ArrayList<String>();
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            fis = new FileInputStream(datei);
            isr = new InputStreamReader((InputStream)fis, charset);
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return list;
    }

    public static final String optionReader(String attrib) {
        File configf = new File(String.valueOf(Start.stamm) + "/Modinstaller/config.txt");
        String text = null;
        boolean exist = false;
        String[] inhalt = null;
        try {
            inhalt = OP.Textreader(configf);
            int i = 0;
            while (i < inhalt.length) {
                if (inhalt[i].split(":")[0].equals(attrib)) {
                    text = inhalt[i].split(":")[1];
                    exist = true;
                }
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!exist) {
            text = "n/a";
        }
        return text;
    }

    public static final void optionWriter(String attrib, String content) {
        File configf = new File(String.valueOf(Start.stamm) + "/Modinstaller/config.txt");
        String[] inhalt = null;
        boolean inside = false;
        if (configf.exists()) {
            try {
                inhalt = OP.Textreader(configf);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            int i = 0;
            while (i < inhalt.length) {
                if (inhalt[i].split(":")[0].equals(attrib)) {
                    inhalt[i] = String.valueOf(inhalt[i].split(":")[0]) + ":" + content;
                    inside = true;
                }
                ++i;
            }
        }
        if (inside) {
            try {
                OP.Textwriter(configf, inhalt, false);
            }
            catch (IOException i) {}
        } else {
            String[] neu = new String[]{String.valueOf(attrib) + ":" + content};
            try {
                OP.Textwriter(configf, neu, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getSizeAsString(double size) {
        String unit = "Byte";
        if (size > 1024.0) {
            size /= 1024.0;
            unit = "KB";
        }
        if (size > 1024.0) {
            size /= 1024.0;
            unit = "MB";
        }
        if (size > 1024.0) {
            size /= 1024.0;
            unit = "GB";
        }
        size = (double)Math.round(size * 10.0) / 10.0;
        return String.valueOf(String.valueOf(size)) + " " + unit;
    }

    public String getInternalText(String internalFile) {
        String json = "";
        Scanner scan = null;
        try {
            scan = new Scanner(this.getClass().getResourceAsStream(internalFile), "UTF-8");
            while (scan.hasNextLine()) {
                json = String.valueOf(json) + scan.nextLine();
            }
        }
        finally {
            if (scan != null) {
                scan.close();
            }
        }
        return json;
    }

    public static final String getError(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }
}

