/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.Browser;
import installer.Download;
import installer.Error;
import installer.Fullscreen;
import installer.Import;
import installer.Install;
import installer.MenuGUI;
import installer.Modinfo;
import installer.OP;
import installer.Read;
import installer.Start;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class Menu
extends MenuGUI
implements ActionListener,
MouseListener,
ChangeListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    public String mineord = Start.mineord;
    public String stamm = Start.stamm;
    public String mcVersion = Start.mcVersion;
    private boolean online = Start.online;
    private double proz = 0.0;
    private double rating = 0.0;
    private boolean manual = false;
    private ArrayList<Modinfo> modlArrL = new ArrayList();
    private ArrayList<Modinfo> forgeArrL = new ArrayList();
    private ArrayList<Modinfo> proposals = new ArrayList();
    private Modinfo[] modtexts;
    private Modinfo[] moddownloads;
    private JList leftList;
    private DefaultListModel leftListModel;
    private int modID = -1;
    private String YT = "";
    private boolean importmod = false;
    private boolean searchfocus = false;
    private boolean ist = false;
    private String modx = "";
    private File impo = new File(String.valueOf(this.stamm) + "Modinstaller/Importo");
    private Thread bart = null;
    private Thread picThread = null;
    public static boolean isModloader = true;

    public Menu(Modinfo[] modtexts, Modinfo[] moddownloads) {
        this.modtexts = modtexts;
        this.moddownloads = moddownloads;
        this.GUI();
        this.setVisible(true);
        this.load();
    }

    private void load() {
        if (this.online) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Menu.this.picture.setIcon(new ImageIcon(this.getClass().getResource("src/wait.gif")));
                    Menu.this.tabbedPane.setEnabled(false);
                    Menu.this.modlArrL.clear();
                    Menu.this.forgeArrL.clear();
                    OP.del(new File(String.valueOf(Menu.this.stamm) + "Modinstaller/Import"));
                    try {
                        int k = 0;
                        while (k < Menu.this.moddownloads.length) {
                            if (Menu.this.moddownloads[k].getMC().equals(Menu.this.mcVersion) && Menu.this.moddownloads[k].getCat() == 0) {
                                Menu.this.modlArrL.add(Menu.this.moddownloads[k]);
                            } else if (Menu.this.moddownloads[k].getMC().equals(Menu.this.mcVersion) && Menu.this.moddownloads[k].getCat() == 3) {
                                Menu.this.forgeArrL.add(Menu.this.moddownloads[k]);
                            }
                            ++k;
                        }
                    }
                    catch (Exception ex) {
                        new Error(OP.getError(ex));
                    }
                    if (Menu.this.forgeArrL.size() > 0) {
                        Menu.this.tabbedPane.setEnabled(true);
                    }
                    if (Menu.this.forgeArrL.size() >= Menu.this.modlArrL.size()) {
                        Menu.this.setForge();
                    } else {
                        Menu.this.setModloader();
                    }
                }
            });
        } else {
            this.setOffline(true);
        }
    }

    private void setOffline(boolean off) {
        if (off) {
            this.online = false;
            this.leftListMModel.removeAllElements();
            this.leftListFModel.removeAllElements();
            this.rightListModel.removeAllElements();
            this.searchInput.setEnabled(false);
            this.selectArrow.setEnabled(false);
            this.setImport(true);
        } else {
            this.online = true;
            this.searchInput.setEnabled(true);
            this.selectArrow.setEnabled(true);
        }
    }

    private void setModloader() {
        this.resetSelection();
        this.leftListModel = this.leftListMModel;
        this.leftList = this.leftListM;
        isModloader = true;
        this.proposals = this.modlArrL;
        this.tabbedPane.setSelectedIndex(0);
        this.sortOutInstalledMods();
        this.ist = true;
    }

    private void setForge() {
        this.resetSelection();
        this.leftListModel = this.leftListFModel;
        this.leftList = this.leftListF;
        isModloader = false;
        this.proposals = this.forgeArrL;
        this.tabbedPane.setSelectedIndex(1);
        this.sortOutInstalledMods();
        this.ist = true;
    }

    private void resetSelection() {
        for (Modinfo prop : this.proposals) {
            prop.setSelect(false);
        }
    }

    private void sortOutInstalledMods() {
        String Mode = "Modloader";
        if (!isModloader) {
            Mode = "Forge";
        }
        if (OP.optionReader("lastmc").equals(this.mcVersion) && OP.optionReader("lastmode").equals(Mode)) {
            try {
                String alastm = OP.optionReader("lastmods");
                String[] stringArray = alastm.split(";;");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String laste = stringArray[n2];
                    for (Modinfo prop : this.proposals) {
                        if (!laste.matches("[0-9]+") || Integer.parseInt(laste) != prop.getID()) continue;
                        prop.setSelect(true);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                new Error(OP.getError(e));
            }
        }
        this.updateLists();
        this.loadTexts();
    }

    public void updateLists() {
        this.leftListModel.removeAllElements();
        this.rightListModel.removeAllElements();
        this.searchInput.reset();
        this.leftList.setEnabled(true);
        this.leftList.requestFocusInWindow();
        for (Modinfo prop : this.proposals) {
            if (prop.getSelect()) {
                this.rightListModel.addElement(prop.getName());
                continue;
            }
            this.leftListModel.addElement(prop.getName());
        }
        new Thread(){

            @Override
            public void run() {
                File impf = new File(String.valueOf(Menu.this.stamm) + "Modinstaller/Import");
                String mode = "Forge";
                if (isModloader) {
                    mode = "Modloader";
                }
                if (OP.optionReader("lastmc").equals(Menu.this.mcVersion) && OP.optionReader("lastmode").equals(mode) && Menu.this.impo.exists()) {
                    try {
                        OP.rename(Menu.this.impo, impf);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (impf.exists()) {
                    File[] imports;
                    File[] fileArray = imports = impf.listFiles();
                    int n = imports.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File modi = fileArray[n2];
                        String name = modi.getName().substring(0, modi.getName().lastIndexOf("."));
                        Menu.this.rightListModel.addElement("+ " + name);
                        ++n2;
                    }
                }
            }
        }.start();
        if (this.bart != null) {
            this.bart.interrupt();
        }
        this.bart = new Thread(){

            @Override
            public void run() {
                String zeile = "";
                for (Modinfo prop : Menu.this.proposals) {
                    if (!prop.getSelect()) continue;
                    zeile = String.valueOf(zeile) + String.valueOf(prop.getID()) + ";;";
                }
                if (zeile.length() > 1) {
                    zeile = zeile.substring(0, zeile.length() - 2);
                }
                String res = "";
                try {
                    res = new Download().post("http://www.minecraft-installer.de/api/compGet.php", "Mods=" + zeile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!res.equals("")) {
                    int val = -1;
                    try {
                        val = (int)Double.parseDouble(res);
                    }
                    catch (Exception e) {
                        val = -1;
                    }
                    if (val == -1) {
                        Menu.this.bar.setVisible(false);
                    } else {
                        Menu.this.bar.setVisible(true);
                        Menu.this.bar.setValue(val);
                    }
                } else {
                    Menu.this.bar.setVisible(false);
                }
            }
        };
        this.bart.start();
    }

    private void loadTexts() {
        if (this.leftListModel.isEmpty()) {
            if (!this.rightListModel.isEmpty()) {
                this.rightList.setSelectedIndex(0);
                this.setInfoText((String)this.rightListModel.get(0));
            }
        } else {
            this.leftList.setSelectedIndex(0);
            this.setInfoText((String)this.leftListModel.get(0));
        }
    }

    private void changeVersion() {
        this.ist = false;
        this.resetSelection();
        this.modDescPane.setText(Read.getTextwith("seite2", "wait"));
        Start.mcVersion = Start.mcVersionen[this.mcVersDrop.getSelectedIndex()];
        this.mcVersion = Start.mcVersionen[this.mcVersDrop.getSelectedIndex()];
        this.load();
    }

    private void setInfoText(final String modname) {
        this.setImport(false);
        this.modNameLabel.setText(modname);
        this.picture.setIcon(new ImageIcon(this.getClass().getResource("src/wait.gif")));
        Modinfo[] modinfoArray = this.modtexts;
        int n = this.modtexts.length;
        int n2 = 0;
        while (n2 < n) {
            Modinfo modt = modinfoArray[n2];
            if (modt.getName().equals(modname)) {
                try {
                    String inh = modt.getText();
                    this.modID = modt.getID();
                    this.website = modt.getSource();
                    this.hyperlink = String.valueOf(Read.getTextwith("installer", "website")) + "/modinfo.php?modname=" + modname.replace(" ", "+");
                    if (!inh.startsWith("<html>")) {
                        inh = "<html><body>" + inh + "</body></html>";
                    }
                    this.modDescPane.setText(inh);
                    this.modDescPane.setCaretPosition(0);
                    this.manual = false;
                    Modinfo[] modinfoArray2 = this.moddownloads;
                    int n3 = this.moddownloads.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Modinfo modd = modinfoArray2[n4];
                        if (modd.getName().equals(modname) && modd.getMC().equals(this.mcVersion)) {
                            this.proz = modd.getRating();
                            if (this.proz > 6.5) {
                                this.topIcon.setIcon(new ImageIcon(this.getClass().getResource("src/top.png")));
                                this.topIcon.setVisible(true);
                            } else {
                                this.topIcon.setVisible(false);
                            }
                            if (modd.getDate() != null) {
                                long DAY_IN_MS = 86400000L;
                                Timestamp sevendago = new Timestamp(new Date(System.currentTimeMillis() - 7L * DAY_IN_MS).getTime());
                                Timestamp modst = modd.getDate();
                                if (modst.after(sevendago)) {
                                    this.topIcon.setIcon(new ImageIcon(this.getClass().getResource("src/new.png")));
                                    this.topIcon.setVisible(true);
                                }
                            } else {
                                this.topIcon.setVisible(false);
                            }
                            this.sizeLabel.setText(new OP().getSizeAsString(modd.getSize()));
                            this.setRating(this.proz, false);
                            break;
                        }
                        ++n4;
                    }
                }
                catch (Exception e) {
                    new Error(OP.getError(e));
                }
            }
            ++n2;
        }
        if (this.picThread != null) {
            this.picThread.interrupt();
        }
        this.picThread = new Thread(){

            @Override
            public void run() {
                try {
                    String url = "http://www.minecraft-installer.de/Dateien/BilderPre/" + modname + ".jpg";
                    url = url.replace(" ", "%20");
                    BufferedImage img = ImageIO.read(new URL(url));
                    Menu.this.picture.setIcon(new ImageIcon(img));
                    img.flush();
                    Menu.this.picture.setText("");
                }
                catch (Exception e) {
                    Menu.this.picture.setText(Read.getTextwith("seite2", "nopic"));
                    Menu.this.picture.setIcon(null);
                }
            }
        };
        this.picThread.start();
    }

    private void selectMod() {
        Object[] listitems;
        Object[] objectArray = listitems = this.leftList.getSelectedValues();
        int n = listitems.length;
        int n2 = 0;
        while (n2 < n) {
            Object listitem = objectArray[n2];
            for (Modinfo prop : this.proposals) {
                if (!prop.getName().equals(listitem)) continue;
                prop.setSelect(true);
            }
            ++n2;
        }
        this.updateLists();
        this.nextButton.setEnabled(true);
        if (this.searchfocus) {
            this.searchInput.requestFocus();
        }
        this.searchfocus = false;
    }

    private void removeMod() {
        if (this.rightList.isFocusOwner()) {
            Object[] listitems;
            Object[] objectArray = listitems = this.rightList.getSelectedValues();
            int n = listitems.length;
            int n2 = 0;
            while (n2 < n) {
                Object listitem = objectArray[n2];
                String name = String.valueOf(listitem);
                if (name.substring(0, 1).equals("+")) {
                    name = name.substring(2);
                    OP.del(new File(String.valueOf(this.stamm) + "Modinstaller/Import/" + name));
                    OP.del(new File(String.valueOf(this.stamm) + "Modinstaller/Import/" + name + ".jar"));
                    OP.del(new File(String.valueOf(this.stamm) + "Modinstaller/Importn/" + name + "/"));
                } else {
                    this.leftList.setEnabled(true);
                    for (Modinfo prop : this.proposals) {
                        if (!prop.getName().equals(listitem)) continue;
                        prop.setSelect(false);
                    }
                }
                ++n2;
            }
            this.updateLists();
            this.nextButton.setEnabled(true);
            if (this.rightListModel.getSize() == 0) {
                this.nextButton.setEnabled(false);
            }
        }
    }

    private void startInstallation() {
        try {
            ArrayList<Modinfo> selected = new ArrayList<Modinfo>();
            for (Modinfo prop : this.proposals) {
                if (!prop.getSelect()) continue;
                selected.add(prop);
            }
            this.dispose();
            new Install(selected, isModloader);
        }
        catch (Exception ex) {
            new Error(String.valueOf(OP.getError(ex)) + "\n\nErrorcode: S2x09");
        }
    }

    private void importMod() {
        this.setImport(true);
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(true);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Mods (.jar, .zip)", "jar", "zip");
        chooser.setFileFilter(filter);
        int rueckgabeWert = chooser.showOpenDialog(this);
        if (rueckgabeWert == 0) {
            File[] fileArray = chooser.getSelectedFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File modfile = fileArray[n2];
                new Import(modfile, (MenuGUI)this);
                ++n2;
            }
        }
    }

    public void setImport(boolean yes) {
        if (yes) {
            this.picture.setIcon(new ImageIcon(this.getClass().getResource("src/importbig.png")));
            if (isModloader) {
                this.modNameLabel.setText(Read.getTextwith("seite2", "importmh"));
                this.modDescPane.setText(Read.getTextwith("seite2", "importm"));
            } else {
                this.modNameLabel.setText(Read.getTextwith("seite2", "importfh"));
                this.modDescPane.setText(Read.getTextwith("seite2", "importf"));
            }
        }
        this.modDescPane.setCaretPosition(0);
        this.importmod = yes;
        this.modinstWebLnk.setVisible(!yes);
        this.modVersionL.setVisible(yes);
        this.topIcon.setVisible(!yes);
        JLabel[] jLabelArray = this.ratIcons;
        int n = this.ratIcons.length;
        int n2 = 0;
        while (n2 < n) {
            JLabel ic = jLabelArray[n2];
            ic.setVisible(!yes);
            ++n2;
        }
    }

    private void restore() {
        OP.del(new File(String.valueOf(this.mineord) + "versions/Modinstaller"));
        try {
            OP.copy(new File(String.valueOf(this.stamm) + "Modinstaller/Backup/Modinstaller.jar"), new File(String.valueOf(this.mineord) + "versions/Modinstaller.jar"));
            OP.copy(new File(String.valueOf(this.stamm) + "Modinstaller/Backup/Modinstaller.json"), new File(String.valueOf(this.mineord) + "versions/Modinstaller.json"));
            OP.copy(new File(String.valueOf(this.stamm) + "Modinstaller/Backup/mods"), new File(String.valueOf(this.mineord) + "mods"));
            JOptionPane.showMessageDialog(null, Read.getTextwith("seite2", "restore"), Read.getTextwith("seite2", "restoreh"), 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OP.optionWriter("lastmods", OP.optionReader("slastmods"));
        OP.optionWriter("slastmods", OP.optionReader("n/a"));
        OP.optionWriter("lastmc", OP.optionReader("slastmc"));
        OP.optionWriter("slastmc", OP.optionReader("n/a"));
        OP.optionWriter("lastmode", OP.optionReader("slastmode"));
        OP.optionWriter("slastmode", OP.optionReader("n/a"));
        this.restoreButton.setEnabled(false);
    }

    private void setRating(double stars, boolean manual) {
        JLabel[] jLabelArray = this.ratIcons;
        int n = this.ratIcons.length;
        int n2 = 0;
        while (n2 < n) {
            JLabel s = jLabelArray[n2];
            if (stars > 0.75) {
                if (manual) {
                    s.setIcon(new ImageIcon(this.getClass().getResource("src/star1b.png")));
                } else {
                    s.setIcon(new ImageIcon(this.getClass().getResource("src/star1.png")));
                }
            } else if (stars > 0.25) {
                s.setIcon(new ImageIcon(this.getClass().getResource("src/star05.png")));
            } else {
                s.setIcon(new ImageIcon(this.getClass().getResource("src/star0.png")));
            }
            stars -= 1.0;
            ++n2;
        }
    }

    private void leftListItemSelected(MouseEvent e) {
        JList list = (JList)e.getSource();
        int index = list.locationToIndex(e.getPoint());
        if (e.getClickCount() == 2 || e.getButton() == 3) {
            this.selectMod();
        } else if (e.getButton() == 1 && this.leftListModel.getSize() > 0 && this.leftList.isEnabled()) {
            String Auswahl = (String)this.leftListModel.getElementAt(index);
            if (!this.modNameLabel.getText().equals(Auswahl)) {
                this.setInfoText(Auswahl);
            }
        }
    }

    private void rightListItemSelected(MouseEvent e) {
        if (this.rightListModel.getSize() > 0 && this.rightList.isEnabled()) {
            JList list = (JList)e.getSource();
            int index = list.locationToIndex(e.getPoint());
            final String Auswahl = (String)this.rightListModel.getElementAt(index);
            if (e.getClickCount() == 2 || e.getButton() == 3) {
                this.removeMod();
            } else if (e.getButton() == 1) {
                if (Auswahl.substring(0, 1).equals("+")) {
                    this.modNameLabel.setText("Loading Mod...");
                    this.picture.setIcon(new ImageIcon(this.getClass().getResource("src/wait.gif")));
                    new Thread(){

                        @Override
                        public void run() {
                            new Import(Auswahl.substring(2), (MenuGUI)Menu.this);
                        }
                    }.start();
                } else if (!this.modNameLabel.getText().equals(Auswahl)) {
                    this.setInfoText(Auswahl);
                }
            }
        }
    }

    private void enterSearchText(KeyEvent e) {
        int si = this.leftList.getSelectedIndex();
        if (e.getKeyCode() == 40) {
            this.leftList.setSelectedIndex(si + 1);
            this.setInfoText(this.leftList.getSelectedValue().toString());
        } else if (e.getKeyCode() == 38) {
            if (si != 0) {
                this.leftList.setSelectedIndex(si - 1);
                this.setInfoText(this.leftList.getSelectedValue().toString());
            }
        } else if (e.getKeyCode() == 10 || e.getKeyCode() == 39) {
            this.searchfocus = true;
            this.selectMod();
        } else {
            String modname;
            this.leftListModel.removeAllElements();
            String needle = this.searchInput.getText().toLowerCase().replace(" ", "");
            for (Modinfo prop : this.proposals) {
                modname = prop.getName().toLowerCase().replace(" ", "");
                if (!modname.startsWith(needle) || prop.getSelect()) continue;
                this.leftListModel.addElement(prop.getName());
            }
            for (Modinfo prop : this.proposals) {
                modname = prop.getName().toLowerCase().replace(" ", "");
                if (!modname.contains(needle) || modname.startsWith(needle) || prop.getSelect()) continue;
                this.leftListModel.addElement(prop.getName());
            }
            if (needle.length() > 2) {
                String needle2 = needle.substring(0, needle.length() - 1);
                if (needle2.length() > 2) {
                    needle2 = needle.substring(1, needle2.length());
                }
                for (Modinfo prop : this.proposals) {
                    String modname2 = prop.getName().toLowerCase().replace(" ", "");
                    if (modname2.contains(needle) || modname2.startsWith(needle) || !modname2.contains(needle2) || prop.getSelect()) continue;
                    this.leftListModel.addElement(prop.getName());
                }
            }
            if (this.leftListModel.size() > 0) {
                if (!this.modx.equals(this.leftListModel.getElementAt(0))) {
                    this.modx = this.leftListModel.getElementAt(0).toString();
                    this.setInfoText(this.modx);
                }
                this.leftList.setSelectedIndex(0);
                this.leftListMSP.getVerticalScrollBar().setValue(0);
                this.leftListFSP.getVerticalScrollBar().setValue(0);
                this.leftList.setEnabled(true);
            } else {
                this.leftListModel.addElement(Read.getTextwith("seite2", "searchn"));
                this.leftList.setEnabled(false);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object s = e.getSource();
        if (s == this.selectArrow) {
            this.selectMod();
        } else if (s == this.removeArrow) {
            this.removeMod();
        } else if (s == this.importButton) {
            this.importMod();
        } else if (s == this.restoreButton) {
            if (this.restoreButton.isEnabled()) {
                this.restore();
            }
        } else if (s == this.helpButton) {
            new Browser(String.valueOf(Read.getTextwith("installer", "website")) + "/faq.php");
        } else if (s == this.videoButton) {
            new Browser(this.YT);
        } else if (s == this.modinstWebLnk) {
            if (this.modinstWebLnk.isEnabled()) {
                new Browser(this.hyperlink);
            }
        } else if (s == this.devWebLnk) {
            if (this.devWebLnk.isEnabled()) {
                new Browser(this.website);
            }
        } else if (s == this.picture) {
            if (this.importmod) {
                this.importMod();
            } else if (this.online) {
                new Fullscreen(this.modtexts, this.modNameLabel.getText(), this.proposals);
            }
        } else if (s == this.exitButton) {
            System.exit(0);
        } else if (s == this.minButton) {
            this.setState(1);
        }
        int i = 0;
        while (i < this.ratIcons.length) {
            if (e.getSource() == this.ratIcons[i]) {
                if (this.rating == (double)i) {
                    this.setRating(this.proz, false);
                    this.manual = false;
                    this.rating = -1.0;
                } else {
                    this.setRating(i + 1, true);
                    this.manual = true;
                    this.rating = i;
                    try {
                        String body = "modID=" + this.modID + "&rating=" + (this.rating + 1.0);
                        new Download().post("http://www.minecraft-installer.de/api/modrating.php", body);
                    }
                    catch (Exception er) {
                        new Error(OP.getError(er));
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        Object s = e.getSource();
        int i = 0;
        while (i < this.ratIcons.length) {
            if (s == this.ratIcons[i] && !this.manual) {
                this.setRating(i + 1, true);
            }
            ++i;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        Object s = e.getSource();
        int i = 0;
        while (i < this.ratIcons.length) {
            if (s == this.ratIcons[i]) {
                if (this.manual) {
                    this.setRating(this.rating + 1.0, true);
                } else {
                    this.setRating(this.proz, false);
                }
            }
            ++i;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Object s = e.getSource();
        if (s == this.leftList) {
            this.leftListItemSelected(e);
        } else if (s == this.rightList) {
            this.rightListItemSelected(e);
        } else if (s == this.nextButton && this.nextButton.isEnabled()) {
            this.startInstallation();
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object s = e.getSource();
        if (s == this.mcVersDrop) {
            this.changeVersion();
        }
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        if (this.tabbedPane.isEnabled() && arg0.getSource() == this.tabbedPane && this.ist) {
            if (this.tabbedPane.getSelectedIndex() == 0) {
                this.setModloader();
            } else {
                this.setForge();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.enterSearchText(e);
    }
}

