/*
 * Decompiled with CFR 0.152.
 */
package org.spout.nbt.stream;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import org.spout.nbt.ByteArrayTag;
import org.spout.nbt.ByteTag;
import org.spout.nbt.CompoundMap;
import org.spout.nbt.CompoundTag;
import org.spout.nbt.DoubleTag;
import org.spout.nbt.EndTag;
import org.spout.nbt.FloatTag;
import org.spout.nbt.IntArrayTag;
import org.spout.nbt.IntTag;
import org.spout.nbt.ListTag;
import org.spout.nbt.LongTag;
import org.spout.nbt.NBTConstants;
import org.spout.nbt.NBTUtils;
import org.spout.nbt.ShortArrayTag;
import org.spout.nbt.ShortTag;
import org.spout.nbt.StringTag;
import org.spout.nbt.Tag;

public final class NBTInputStream
implements Closeable {
    private final DataInputStream is;
    private final boolean littleEndian;

    public NBTInputStream(InputStream is) throws IOException {
        this(is, true, false);
    }

    public NBTInputStream(InputStream is, boolean compressed) throws IOException {
        this(is, compressed, false);
    }

    public NBTInputStream(InputStream is, boolean compressed, boolean littleEndian) throws IOException {
        this.littleEndian = littleEndian;
        this.is = new DataInputStream(compressed ? new GZIPInputStream(is) : is);
    }

    public Tag readTag() throws IOException {
        return this.readTag(0);
    }

    private Tag readTag(int depth) throws IOException {
        String name;
        int type = this.is.readByte() & 0xFF;
        if (type != 0) {
            int nameLength = this.is.readShort() & 0xFFFF;
            if (this.littleEndian) {
                nameLength = Short.reverseBytes((short)nameLength);
            }
            byte[] nameBytes = new byte[nameLength];
            this.is.readFully(nameBytes);
            name = new String(nameBytes, NBTConstants.CHARSET.name());
        } else {
            name = "";
        }
        return this.readTagPayload(type, name, depth);
    }

    private Tag readTagPayload(int type, String name, int depth) throws IOException {
        switch (type) {
            case 0: {
                if (depth == 0) {
                    throw new IOException("TAG_End found without a TAG_Compound/TAG_List tag preceding it.");
                }
                return new EndTag();
            }
            case 1: {
                return new ByteTag(name, this.is.readByte());
            }
            case 2: {
                return new ShortTag(name, this.littleEndian ? Short.reverseBytes(this.is.readShort()) : this.is.readShort());
            }
            case 3: {
                return new IntTag(name, this.littleEndian ? Integer.reverseBytes(this.is.readInt()) : this.is.readInt());
            }
            case 4: {
                return new LongTag(name, this.littleEndian ? Long.reverseBytes(this.is.readLong()) : this.is.readLong());
            }
            case 5: {
                return new FloatTag(name, this.littleEndian ? Float.intBitsToFloat(Integer.reverseBytes(this.is.readInt())) : this.is.readFloat());
            }
            case 6: {
                return new DoubleTag(name, this.littleEndian ? Double.longBitsToDouble(Long.reverseBytes(this.is.readLong())) : this.is.readDouble());
            }
            case 7: {
                int length = this.littleEndian ? Integer.reverseBytes(this.is.readInt()) : this.is.readInt();
                byte[] bytes = new byte[length];
                this.is.readFully(bytes);
                return new ByteArrayTag(name, bytes);
            }
            case 8: {
                short length = this.littleEndian ? Short.reverseBytes(this.is.readShort()) : this.is.readShort();
                byte[] bytes = new byte[length];
                this.is.readFully(bytes);
                return new StringTag(name, new String(bytes, NBTConstants.CHARSET.name()));
            }
            case 9: {
                byte childType = this.is.readByte();
                int length = this.littleEndian ? Integer.reverseBytes(this.is.readInt()) : this.is.readInt();
                Class<? extends Tag> clazz = NBTUtils.getTypeClass(childType);
                ArrayList<Tag> tagList = new ArrayList<Tag>();
                for (int i = 0; i < length; ++i) {
                    Tag tag = this.readTagPayload(childType, "", depth + 1);
                    if (tag instanceof EndTag) {
                        throw new IOException("TAG_End not permitted in a list.");
                    }
                    if (!clazz.isInstance(tag)) {
                        throw new IOException("Mixed tag types within a list.");
                    }
                    tagList.add(tag);
                }
                return new ListTag<Tag>(name, clazz, tagList);
            }
            case 10: {
                Tag tag;
                CompoundMap compoundTagList = new CompoundMap();
                while (!((tag = this.readTag(depth + 1)) instanceof EndTag)) {
                    compoundTagList.put(tag);
                }
                return new CompoundTag(name, compoundTagList);
            }
            case 11: {
                int length = this.littleEndian ? Integer.reverseBytes(this.is.readInt()) : this.is.readInt();
                int[] ints = new int[length];
                for (int i = 0; i < length; ++i) {
                    ints[i] = this.littleEndian ? Integer.reverseBytes(this.is.readInt()) : this.is.readInt();
                }
                return new IntArrayTag(name, ints);
            }
            case 100: {
                int length = this.littleEndian ? Integer.reverseBytes(this.is.readInt()) : this.is.readInt();
                short[] shorts = new short[length];
                for (int i = 0; i < length; ++i) {
                    shorts[i] = this.littleEndian ? Short.reverseBytes(this.is.readShort()) : this.is.readShort();
                }
                return new ShortArrayTag(name, shorts);
            }
        }
        throw new IOException("Invalid tag type: " + type + ".");
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    public boolean isLittleEndian() {
        return this.littleEndian;
    }
}

