/*
 * Decompiled with CFR 0.152.
 */
package installer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicProgressBarUI;

class GradientPalletProgressBarUI
extends BasicProgressBarUI {
    private final int[] pallet = GradientPalletProgressBarUI.makeGradientPallet();

    private static int[] makeGradientPallet() {
        BufferedImage image = new BufferedImage(100, 1, 1);
        Graphics2D g2 = image.createGraphics();
        Point2D.Float start = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float end = new Point2D.Float(99.0f, 0.0f);
        float[] dist = new float[]{0.0f, 0.5f, 1.0f};
        Color[] colors = new Color[]{Color.decode("#9C2717"), Color.ORANGE, Color.green};
        g2.setPaint(new LinearGradientPaint(start, end, dist, colors));
        g2.fillRect(0, 0, 100, 1);
        g2.dispose();
        int width = image.getWidth(null);
        int[] pallet = new int[width];
        PixelGrabber pg = new PixelGrabber(image, 0, 0, width, 1, pallet, 0, width);
        try {
            pg.grabPixels();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pallet;
    }

    private static Color getColorFromPallet(int[] pallet, float x) {
        if ((double)x < 0.0 || (double)x > 1.0) {
            throw new IllegalArgumentException("Parameter outside of expected range");
        }
        int i = (int)((float)pallet.length * x);
        int max = pallet.length - 1;
        int index = i < 0 ? 0 : (i > max ? max : i);
        int pix = pallet[index] & 0xFFFFFF | 0x64000000;
        return new Color(pix, true);
    }

    @Override
    public void paintDeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        if (this.progressBar.getOrientation() == 0) {
            g.setColor(GradientPalletProgressBarUI.getColorFromPallet(this.pallet, 1.0f));
            g.fillRect(b.left, b.top, amountFull, barRectHeight);
            g.setColor(GradientPalletProgressBarUI.getColorFromPallet(this.pallet, 0.0f));
            g.fillRect(b.left + amountFull, b.top, this.progressBar.getWidth() - amountFull, barRectHeight);
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
        }
    }
}

