/*
 * Decompiled with CFR 0.152.
 */
package org.spout.nbt;

import java.util.HashMap;
import java.util.Map;

public abstract class Tag
implements Comparable<Tag> {
    private final String name;

    public Tag() {
        this("");
    }

    public Tag(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public abstract Object getValue();

    public static Map<String, Tag> cloneMap(Map<String, Tag> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, Tag> newMap = new HashMap<String, Tag>();
        for (Map.Entry<String, Tag> entry : map.entrySet()) {
            newMap.put(entry.getKey(), entry.getValue().clone());
        }
        return newMap;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Tag)) {
            return false;
        }
        Tag tag = (Tag)other;
        return this.getValue().equals(tag.getValue()) && this.getName().equals(tag.getName());
    }

    @Override
    public int compareTo(Tag o) {
        if (this.equals(o)) {
            return 0;
        }
        Tag other = o;
        if (other.getName().equals(this.getName())) {
            throw new IllegalStateException("Cannot compare two Tags with the same name but different values for sorting");
        }
        return this.getName().compareTo(other.getName());
    }

    public abstract Tag clone();
}

