/*
 * Decompiled with CFR 0.152.
 */
package installer;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JPanel;

public class GraphicsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private MediaTracker tracker = new MediaTracker(this);
    private BufferedImage texture;
    private boolean singlePaint;

    public GraphicsPanel(boolean sp, String URL2) {
        this.singlePaint = sp;
        this.texture = this.loadTexture(URL2);
    }

    public GraphicsPanel(boolean sp) {
        this.singlePaint = sp;
        this.texture = this.loadTexture("http://www.minecraft-installer.de/Dateien/modinstallerbg.png");
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.texture == null) {
            return;
        }
        if (this.singlePaint) {
            g2.drawImage(this.texture, null, 100, 100);
        } else {
            Rectangle r = new Rectangle(-1, -1, this.texture.getWidth(), this.texture.getHeight());
            TexturePaint paint = new TexturePaint(this.texture, r);
            Dimension dim = this.getSize();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.setPaint(paint);
            g2.fillRect(0, 0, dim.width, dim.height);
        }
    }

    private BufferedImage loadTexture(String URL2) {
        BufferedImage bufferedImage;
        Image image;
        block19: {
            image = null;
            bufferedImage = null;
            URL url = null;
            try {
                url = new URL(URL2);
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
            if (url == null) {
                return null;
            }
            image = Toolkit.getDefaultToolkit().getImage(url);
            if (image != null) {
                this.tracker.addImage(image, 0);
                try {
                    try {
                        this.tracker.waitForAll();
                    }
                    catch (InterruptedException e) {
                        this.tracker.removeImage(image);
                        image = null;
                        if (image != null) {
                            this.tracker.removeImage(image);
                        }
                        if (this.tracker.isErrorAny()) {
                            image = null;
                        }
                        if (image != null && (image.getWidth(null) < 0 || image.getHeight(null) < 0)) {
                            image = null;
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (image != null) {
                        this.tracker.removeImage(image);
                    }
                    if (this.tracker.isErrorAny()) {
                        image = null;
                    }
                    if (image != null && (image.getWidth(null) < 0 || image.getHeight(null) < 0)) {
                        image = null;
                    }
                    throw throwable;
                }
                if (image != null) {
                    this.tracker.removeImage(image);
                }
                if (this.tracker.isErrorAny()) {
                    image = null;
                }
                if (image != null && (image.getWidth(null) < 0 || image.getHeight(null) < 0)) {
                    image = null;
                }
            }
        }
        if (image != null) {
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
            Graphics2D g = bufferedImage.createGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
        }
        return bufferedImage;
    }
}

