/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.Install;
import installer.OP;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

public class Compress {
    private File sourcecpy;
    private BufferedInputStream buffinstr;
    private JarOutputStream zipOut;

    public Compress(File source, File target) {
        this.sourcecpy = source;
        OP.makedirs(target.getParentFile());
        try {
            this.zipOut = new JarOutputStream(new FileOutputStream(target));
        }
        catch (Exception ex) {
            Install.Fehler = String.valueOf(Install.Fehler) + OP.getError(ex) + "\n\n";
        }
        this.zip(source);
        try {
            this.zipOut.close();
        }
        catch (Exception ex) {
            Install.Fehler = String.valueOf(Install.Fehler) + OP.getError(ex) + "\n\n";
        }
    }

    public Compress() {
    }

    public void zip(File source) {
        try {
            try {
                File[] files = source.listFiles();
                if (files != null) {
                    int i = 0;
                    while (i < files.length) {
                        if (files[i].isDirectory()) {
                            this.zip(files[i]);
                        } else {
                            String eintragname;
                            this.buffinstr = new BufferedInputStream(new FileInputStream(files[i]));
                            int avail = this.buffinstr.available();
                            byte[] buffer = new byte[avail];
                            if (avail > 0) {
                                this.buffinstr.read(buffer, 0, avail);
                            }
                            if ((eintragname = files[i].getAbsolutePath().substring(this.sourcecpy.getAbsolutePath().length()).replace("\\", "/").substring(1)).equals("_aux.class")) {
                                eintragname = "aux.class";
                            }
                            JarEntry ze = new JarEntry(eintragname);
                            this.zipOut.putNextEntry(ze);
                            this.zipOut.write(buffer, 0, buffer.length);
                            this.zipOut.closeEntry();
                        }
                        ++i;
                    }
                }
            }
            catch (Exception ex) {
                Install.Fehler = String.valueOf(Install.Fehler) + OP.getError(ex) + "\n\n";
                try {
                    if (this.buffinstr != null) {
                        this.buffinstr.close();
                    }
                }
                catch (Exception ex2) {
                    Install.Fehler = String.valueOf(Install.Fehler) + OP.getError(ex2) + "\n\n";
                }
            }
        }
        finally {
            try {
                if (this.buffinstr != null) {
                    this.buffinstr.close();
                }
            }
            catch (Exception ex) {
                Install.Fehler = String.valueOf(Install.Fehler) + OP.getError(ex) + "\n\n";
            }
        }
    }
}

