/*
 * Decompiled with CFR 0.152.
 */
package org.spout.nbt.stream;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.zip.GZIPOutputStream;
import org.spout.nbt.ByteArrayTag;
import org.spout.nbt.ByteTag;
import org.spout.nbt.CompoundTag;
import org.spout.nbt.DoubleTag;
import org.spout.nbt.EndTag;
import org.spout.nbt.FloatTag;
import org.spout.nbt.IntArrayTag;
import org.spout.nbt.IntTag;
import org.spout.nbt.ListTag;
import org.spout.nbt.LongTag;
import org.spout.nbt.NBTConstants;
import org.spout.nbt.NBTUtils;
import org.spout.nbt.ShortArrayTag;
import org.spout.nbt.ShortTag;
import org.spout.nbt.StringTag;
import org.spout.nbt.Tag;

public final class NBTOutputStream
implements Closeable {
    private final DataOutputStream os;
    private final boolean littleEndian;

    public NBTOutputStream(OutputStream os) throws IOException {
        this(os, true, false);
    }

    public NBTOutputStream(OutputStream os, boolean compressed) throws IOException {
        this(os, compressed, false);
    }

    public NBTOutputStream(OutputStream os, boolean compressed, boolean littleEndian) throws IOException {
        this.littleEndian = littleEndian;
        this.os = new DataOutputStream(compressed ? new GZIPOutputStream(os) : os);
    }

    public void writeTag(Tag tag) throws IOException {
        int type = NBTUtils.getTypeCode(tag.getClass());
        String name = tag.getName();
        byte[] nameBytes = name.getBytes(NBTConstants.CHARSET.name());
        this.os.writeByte(type);
        this.os.writeShort(this.littleEndian ? (int)Short.reverseBytes((short)nameBytes.length) : nameBytes.length);
        this.os.write(nameBytes);
        if (type == 0) {
            throw new IOException("Named TAG_End not permitted.");
        }
        this.writeTagPayload(tag);
    }

    private void writeTagPayload(Tag tag) throws IOException {
        int type = NBTUtils.getTypeCode(tag.getClass());
        switch (type) {
            case 0: {
                this.writeEndTagPayload((EndTag)tag);
                break;
            }
            case 1: {
                this.writeByteTagPayload((ByteTag)tag);
                break;
            }
            case 2: {
                this.writeShortTagPayload((ShortTag)tag);
                break;
            }
            case 3: {
                this.writeIntTagPayload((IntTag)tag);
                break;
            }
            case 4: {
                this.writeLongTagPayload((LongTag)tag);
                break;
            }
            case 5: {
                this.writeFloatTagPayload((FloatTag)tag);
                break;
            }
            case 6: {
                this.writeDoubleTagPayload((DoubleTag)tag);
                break;
            }
            case 7: {
                this.writeByteArrayTagPayload((ByteArrayTag)tag);
                break;
            }
            case 8: {
                this.writeStringTagPayload((StringTag)tag);
                break;
            }
            case 9: {
                this.writeListTagPayload((ListTag)tag);
                break;
            }
            case 10: {
                this.writeCompoundTagPayload((CompoundTag)tag);
                break;
            }
            case 11: {
                this.writeIntArrayTagPayload((IntArrayTag)tag);
                break;
            }
            case 100: {
                this.writeShortArrayTagPayload((ShortArrayTag)tag);
                break;
            }
            default: {
                throw new IOException("Invalid tag type: " + type + ".");
            }
        }
    }

    private void writeByteTagPayload(ByteTag tag) throws IOException {
        this.os.writeByte(tag.getValue().byteValue());
    }

    private void writeByteArrayTagPayload(ByteArrayTag tag) throws IOException {
        byte[] bytes = tag.getValue();
        this.os.writeInt(this.littleEndian ? Integer.reverseBytes(bytes.length) : bytes.length);
        this.os.write(bytes);
    }

    private void writeCompoundTagPayload(CompoundTag tag) throws IOException {
        for (Tag childTag : tag.getValue().values()) {
            this.writeTag(childTag);
        }
        this.os.writeByte(0);
    }

    private void writeListTagPayload(ListTag<?> tag) throws IOException {
        Class<?> clazz = tag.getType();
        Object tags = tag.getValue();
        int size = tags.size();
        this.os.writeByte(NBTUtils.getTypeCode(clazz));
        this.os.writeInt(this.littleEndian ? Integer.reverseBytes(size) : size);
        Iterator i$ = tags.iterator();
        while (i$.hasNext()) {
            Tag tag1 = (Tag)i$.next();
            this.writeTagPayload(tag1);
        }
    }

    private void writeStringTagPayload(StringTag tag) throws IOException {
        byte[] bytes = tag.getValue().getBytes(NBTConstants.CHARSET.name());
        this.os.writeShort(this.littleEndian ? (int)Short.reverseBytes((short)bytes.length) : bytes.length);
        this.os.write(bytes);
    }

    private void writeDoubleTagPayload(DoubleTag tag) throws IOException {
        if (this.littleEndian) {
            this.os.writeLong(Long.reverseBytes(Double.doubleToLongBits(tag.getValue())));
        } else {
            this.os.writeDouble(tag.getValue());
        }
    }

    private void writeFloatTagPayload(FloatTag tag) throws IOException {
        if (this.littleEndian) {
            this.os.writeInt(Integer.reverseBytes(Float.floatToIntBits(tag.getValue().floatValue())));
        } else {
            this.os.writeFloat(tag.getValue().floatValue());
        }
    }

    private void writeLongTagPayload(LongTag tag) throws IOException {
        this.os.writeLong(this.littleEndian ? Long.reverseBytes(tag.getValue()) : tag.getValue());
    }

    private void writeIntTagPayload(IntTag tag) throws IOException {
        this.os.writeInt(this.littleEndian ? Integer.reverseBytes(tag.getValue()) : tag.getValue());
    }

    private void writeShortTagPayload(ShortTag tag) throws IOException {
        this.os.writeShort(this.littleEndian ? Short.reverseBytes(tag.getValue()) : tag.getValue());
    }

    private void writeIntArrayTagPayload(IntArrayTag tag) throws IOException {
        int[] ints = tag.getValue();
        this.os.writeInt(this.littleEndian ? Integer.reverseBytes(ints.length) : ints.length);
        for (int i = 0; i < ints.length; ++i) {
            this.os.writeInt(this.littleEndian ? Integer.reverseBytes(ints[i]) : ints[i]);
        }
    }

    private void writeShortArrayTagPayload(ShortArrayTag tag) throws IOException {
        short[] shorts = tag.getValue();
        this.os.writeInt(this.littleEndian ? Integer.reverseBytes(shorts.length) : shorts.length);
        for (int i = 0; i < shorts.length; ++i) {
            this.os.writeShort(this.littleEndian ? Short.reverseBytes(shorts[i]) : shorts[i]);
        }
    }

    private void writeEndTagPayload(EndTag tag) {
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }

    public boolean isLittleEndian() {
        return this.littleEndian;
    }
}

