/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.Browser;
import installer.Download;
import installer.Error;
import installer.Fullscreen;
import installer.Import;
import installer.Install;
import installer.MenuGUI;
import installer.Modinfo;
import installer.OP;
import installer.Read;
import installer.Start;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import javax.imageio.ImageIO;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class Menu
extends MenuGUI
implements ActionListener,
MouseListener,
ChangeListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private String mineord = Start.mineord;
    private String stamm = Start.stamm;
    private String mcVersion = Start.mcVersion;
    private String hyperlink = Read.getTextwith("installer", "website");
    private String website = Read.getTextwith("installer", "website");
    private boolean online = Start.online;
    private double proz = 0.0;
    private double rating = 0.0;
    private boolean manual = false;
    private ArrayList<String> modlArrL = new ArrayList();
    private ArrayList<String> forgeArrL = new ArrayList();
    private Modinfo[] modtexts;
    private Modinfo[] moddownloads;
    private JList<String> leftList;
    private DefaultListModel<String> leftListModel;
    private ArrayList<String> proposal = new ArrayList();
    private ArrayList<String> selected = new ArrayList();
    private boolean importmod = false;
    private boolean sear = false;
    private int downloadsize = 0;
    private int currentsize = 0;
    private String modx = "";
    public static boolean isModloader = true;

    public Menu(Modinfo[] modtexts, Modinfo[] moddownloads) {
        this.modtexts = modtexts;
        this.moddownloads = moddownloads;
        this.GUI();
        this.setVisible(true);
        this.load();
    }

    public Menu() {
    }

    private void load() {
        if (this.online) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Menu.this.picture.setIcon(new ImageIcon(this.getClass().getResource("src/wait.gif")));
                    Menu.this.tabbedPane.setEnabled(false);
                    Menu.this.modlArrL.clear();
                    Menu.this.forgeArrL.clear();
                    OP.del(new File(String.valueOf(Menu.this.stamm) + "Modinstaller/Import"));
                    try {
                        int k = 0;
                        while (k < Menu.this.moddownloads.length) {
                            if (Menu.this.moddownloads[k].getMC().equals(Menu.this.mcVersion) && Menu.this.moddownloads[k].getCat() == 0) {
                                Menu.this.modlArrL.add(Menu.this.moddownloads[k].getName());
                            } else if (Menu.this.moddownloads[k].getMC().equals(Menu.this.mcVersion) && Menu.this.moddownloads[k].getCat() == 3) {
                                Menu.this.forgeArrL.add(Menu.this.moddownloads[k].getName());
                            }
                            ++k;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (Menu.this.forgeArrL.size() > 0) {
                        Menu.this.tabbedPane.setEnabled(true);
                    }
                    if (Menu.this.forgeArrL.size() >= Menu.this.modlArrL.size()) {
                        Menu.this.setForge();
                    } else {
                        Menu.this.setModloader();
                    }
                }
            });
        } else {
            this.setOffline(true);
        }
    }

    private void setOffline(boolean off) {
        if (off) {
            this.online = false;
            this.leftListMModel.removeAllElements();
            this.leftListFModel.removeAllElements();
            this.rightListModel.removeAllElements();
            this.search.setEnabled(false);
            this.selectArrow.setEnabled(false);
            this.setImport();
        } else {
            this.online = true;
            this.search.setEnabled(true);
            this.selectArrow.setEnabled(true);
        }
    }

    private void setModloader() {
        this.leftListModel = this.leftListMModel;
        this.leftList = this.leftListM;
        isModloader = true;
        this.proposal = this.modlArrL;
        this.selected.clear();
        this.tabbedPane.setSelectedIndex(0);
        this.sortOutInstalledMods();
    }

    private void setForge() {
        this.leftListModel = this.leftListFModel;
        this.leftList = this.leftListF;
        isModloader = false;
        this.proposal = this.forgeArrL;
        this.selected.clear();
        this.tabbedPane.setSelectedIndex(1);
        this.sortOutInstalledMods();
    }

    private void sortOutInstalledMods() {
        String Mode = "Modloader";
        if (!isModloader) {
            Mode = "Forge";
        }
        if (OP.optionReader("lastmc").equals(this.mcVersion) && OP.optionReader("lastmode").equals(Mode)) {
            String alastm = OP.optionReader("lastmods");
            String[] lastm = alastm.split(";;");
            int r = 0;
            while (r < lastm.length) {
                int k = 0;
                while (k < this.proposal.size()) {
                    if (lastm[r].equals(this.proposal.get(k))) {
                        this.selected.add(this.proposal.get(k));
                        this.proposal.remove(k);
                    }
                    ++k;
                }
                ++r;
            }
        }
        this.updateLists();
        this.loadTexts();
    }

    public void updateLists() {
        this.leftListModel.removeAllElements();
        this.rightListModel.removeAllElements();
        this.search.reset();
        this.leftList.setEnabled(true);
        this.leftList.requestFocusInWindow();
        Collections.sort(this.proposal);
        for (String mod : this.proposal) {
            this.leftListModel.addElement(mod);
        }
        for (String mod2 : this.selected) {
            this.rightListModel.addElement(mod2);
        }
        File impo = new File(String.valueOf(this.stamm) + "Modinstaller/Import");
        if (impo.exists()) {
            File[] imports;
            File[] fileArray = imports = impo.listFiles();
            int n = imports.length;
            int n2 = 0;
            while (n2 < n) {
                File modi = fileArray[n2];
                String name = modi.getName().substring(0, modi.getName().lastIndexOf("."));
                this.rightListModel.addElement("+ " + name);
                ++n2;
            }
        }
        this.leftListMSP.getVerticalScrollBar().setValue(0);
        this.leftListFSP.getVerticalScrollBar().setValue(0);
    }

    private void loadTexts() {
        if (this.leftListModel.isEmpty()) {
            if (!this.rightListModel.isEmpty()) {
                this.rightList.setSelectedIndex(0);
                this.setInfoText((String)this.rightListModel.get(0));
            }
        } else {
            this.leftList.setSelectedIndex(0);
            this.setInfoText(this.leftListModel.get(0));
        }
    }

    private void changeVersion() {
        this.pane.setText(Read.getTextwith("seite2", "wait"));
        Start.mcVersion = Start.mcVersionen[this.ChVers.getSelectedIndex()];
        this.mcVersion = Start.mcVersionen[this.ChVers.getSelectedIndex()];
        this.load();
    }

    private void setInfoText(final String modname) {
        this.importmod = false;
        this.modtext.setText(modname);
        this.picture.setIcon(new ImageIcon(this.getClass().getResource("src/wait.gif")));
        int i = 0;
        while (i < this.modtexts.length) {
            if (this.modtexts[i].getName().equals(modname)) {
                try {
                    String inh = this.modtexts[i].getText();
                    this.website = this.modtexts[i].getSource();
                    this.hyperlink = String.valueOf(Read.getTextwith("installer", "website")) + "/modinfo.php?modname=" + modname.replace(" ", "+");
                    if (!inh.startsWith("<html>")) {
                        inh = "<html><body>" + inh + "</body></html>";
                    }
                    this.pane.setText(inh);
                    this.pane.setCaretPosition(0);
                    this.manual = false;
                    int j = 0;
                    while (j < this.moddownloads.length) {
                        if (this.moddownloads[j].getName().equals(modname) && this.moddownloads[j].getMC().equals(this.mcVersion)) {
                            this.proz = this.moddownloads[j].getRating();
                            if (this.proz > 6.5) {
                                this.specImg.setVisible(true);
                            } else {
                                this.specImg.setVisible(false);
                            }
                            this.currentsize = this.moddownloads[j].getSize();
                            double size = this.currentsize;
                            String unit = "Byte";
                            if (size > 1024.0) {
                                size /= 1024.0;
                                unit = "KB";
                            }
                            if (size > 1024.0) {
                                size /= 1024.0;
                                unit = "MB";
                            }
                            if (size > 1024.0) {
                                size /= 1024.0;
                                unit = "GB";
                            }
                            size = (double)Math.round(size * 10.0) / 10.0;
                            this.sizeLabel.setText(String.valueOf(String.valueOf(size)) + " " + unit);
                            this.setRating(this.proz, false);
                            break;
                        }
                        ++j;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    String url = "http://www.minecraft-installer.de/Dateien/BilderPre/" + modname + ".jpg";
                    url = url.replace(" ", "%20");
                    BufferedImage img = ImageIO.read(new URL(url));
                    Menu.this.picture.setIcon(new ImageIcon(img));
                    img.flush();
                    Menu.this.picture.setText("");
                }
                catch (Exception e) {
                    Menu.this.picture.setText(Read.getTextwith("seite2", "nopic"));
                    Menu.this.picture.setIcon(null);
                }
            }
        }.start();
    }

    private void selectMod() {
        String listitem = this.leftList.getSelectedValue();
        if (this.proposal.contains(listitem)) {
            this.proposal.remove(listitem);
            this.selected.add(listitem);
            this.downloadsize += this.currentsize;
        }
        this.updateLists();
        this.nextButton.setEnabled(true);
        if (this.sear) {
            this.search.requestFocus();
        }
        this.sear = false;
    }

    private void removeMod() {
        if (this.rightList.isFocusOwner()) {
            String listitem = (String)this.rightList.getSelectedValue();
            if (listitem.substring(0, 1).equals("+")) {
                String name = listitem.substring(2);
                OP.del(new File(String.valueOf(this.stamm) + "Modinstaller/Import/" + name));
                OP.del(new File(String.valueOf(this.stamm) + "Modinstaller/Import/" + name + ".jar"));
                OP.del(new File(String.valueOf(this.stamm) + "Modinstaller/Importn/" + name + "/"));
            } else {
                this.leftList.setEnabled(true);
                this.proposal.add(listitem);
                this.selected.remove(listitem);
                this.downloadsize += this.currentsize;
            }
            this.updateLists();
            this.nextButton.setEnabled(true);
            if (this.rightListModel.getSize() == 0) {
                this.nextButton.setEnabled(false);
            }
        }
    }

    private void startInstallation() {
        try {
            String[] modnames = this.selected.toArray(new String[this.selected.size()]);
            this.dispose();
            new Install(modnames, isModloader, this.downloadsize);
        }
        catch (Exception ex) {
            new Error(String.valueOf(OP.getError(ex)) + "\n\nErrorcode: S2x09");
        }
    }

    private void importMod() {
        this.setImport();
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(true);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Mods (.jar, .zip)", "jar", "zip");
        chooser.setFileFilter(filter);
        int rueckgabeWert = chooser.showOpenDialog(this);
        if (rueckgabeWert == 0) {
            File[] fileArray = chooser.getSelectedFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File modfile = fileArray[n2];
                new Import(modfile, this);
                ++n2;
            }
        }
    }

    private void setImport() {
        this.importmod = true;
        this.picture.setIcon(new ImageIcon(this.getClass().getResource("src/importbig.png")));
        if (isModloader) {
            this.modtext.setText(Read.getTextwith("seite2", "importmh"));
            this.pane.setText(Read.getTextwith("seite2", "importm"));
        } else {
            this.modtext.setText(Read.getTextwith("seite2", "importfh"));
            this.pane.setText(Read.getTextwith("seite2", "importf"));
        }
        this.pane.setCaretPosition(0);
        this.hyperlink = String.valueOf(Read.getTextwith("installer", "website")) + "/faq.php";
        this.setRating(0.0, true);
    }

    private void restore() {
        OP.del(new File(String.valueOf(this.mineord) + "versions/Modinstaller"));
        try {
            OP.copy(new File(String.valueOf(this.stamm) + "Modinstaller/Backup/Modinstaller.jar"), new File(String.valueOf(this.mineord) + "versions/Modinstaller.jar"));
            OP.copy(new File(String.valueOf(this.stamm) + "Modinstaller/Backup/Modinstaller.json"), new File(String.valueOf(this.mineord) + "versions/Modinstaller.json"));
            OP.copy(new File(String.valueOf(this.stamm) + "Modinstaller/Backup/mods"), new File(String.valueOf(this.mineord) + "mods"));
            JOptionPane.showMessageDialog(null, Read.getTextwith("seite2", "restore"), Read.getTextwith("seite2", "restoreh"), 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OP.optionWriter("lastmods", OP.optionReader("slastmods"));
        OP.optionWriter("slastmods", OP.optionReader("n/a"));
        OP.optionWriter("lastmc", OP.optionReader("slastmc"));
        OP.optionWriter("slastmc", OP.optionReader("n/a"));
        OP.optionWriter("lastmode", OP.optionReader("slastmode"));
        OP.optionWriter("slastmode", OP.optionReader("n/a"));
        this.restoreButton.setEnabled(false);
    }

    private void setRating(double bewe, boolean anders) {
        JLabel[] jLabelArray = this.ratIcons;
        int n = this.ratIcons.length;
        int n2 = 0;
        while (n2 < n) {
            JLabel s = jLabelArray[n2];
            if (bewe > 0.75) {
                if (!anders) {
                    s.setIcon(new ImageIcon(this.getClass().getResource("src/star1.png")));
                } else {
                    s.setIcon(new ImageIcon(this.getClass().getResource("src/star1b.png")));
                }
            } else if (bewe > 0.25) {
                s.setIcon(new ImageIcon(this.getClass().getResource("src/star05.png")));
            } else {
                s.setIcon(new ImageIcon(this.getClass().getResource("src/star0.png")));
            }
            bewe -= 1.0;
            ++n2;
        }
    }

    private void leftListItemSelected(MouseEvent e) {
        if (e.getClickCount() == 2 || e.getButton() == 3) {
            this.selectMod();
        } else if (e.getButton() == 1 && this.leftListModel.getSize() > 0 && this.leftList.isEnabled()) {
            String Auswahl = this.leftListModel.getElementAt(this.leftList.getSelectedIndex());
            if (!this.modtext.getText().equals(Auswahl)) {
                this.setInfoText(Auswahl);
            }
        }
    }

    private void rightListItemSelected(MouseEvent e) {
        if (this.rightListModel.getSize() > 0 && this.rightList.isEnabled()) {
            String Auswahl = (String)this.rightListModel.getElementAt(this.rightList.getSelectedIndex());
            if (Auswahl.substring(0, 1).equals("+")) {
                this.setImport();
                if (e.getClickCount() == 2) {
                    new Import(Auswahl.substring(2));
                }
            } else if (e.getClickCount() == 2 || e.getButton() == 3) {
                this.removeMod();
            } else if (e.getButton() == 1 && !this.modtext.getText().equals(Auswahl)) {
                this.setInfoText(Auswahl);
            }
        }
    }

    private void enterSearchText(KeyEvent e) {
        String modname;
        this.leftListModel.removeAllElements();
        String needle = this.search.getText().toLowerCase().replace(" ", "");
        int i = 0;
        while (i < this.proposal.size()) {
            modname = this.proposal.get(i).toLowerCase().replace(" ", "");
            if (modname.startsWith(needle)) {
                this.leftListModel.addElement(this.proposal.get(i));
            }
            ++i;
        }
        i = 0;
        while (i < this.proposal.size()) {
            modname = this.proposal.get(i).toLowerCase().replace(" ", "");
            if (modname.contains(needle) && !modname.startsWith(needle)) {
                this.leftListModel.addElement(this.proposal.get(i));
            }
            ++i;
        }
        if (needle.length() > 2) {
            String needle2 = needle.substring(0, needle.length() - 1);
            if (needle2.length() > 2) {
                needle2 = needle.substring(1, needle2.length());
            }
            int i2 = 0;
            while (i2 < this.proposal.size()) {
                String modname2 = this.proposal.get(i2).toLowerCase().replace(" ", "");
                if (!modname2.contains(needle) && !modname2.startsWith(needle) && modname2.contains(needle2)) {
                    this.leftListModel.addElement(this.proposal.get(i2));
                }
                ++i2;
            }
        }
        if (this.leftListModel.size() > 0) {
            if (!this.modx.equals(this.leftListModel.getElementAt(0))) {
                this.modx = this.leftListModel.getElementAt(0);
                this.setInfoText(this.modx);
            }
            this.leftList.setSelectedIndex(0);
            this.leftList.setEnabled(true);
            if (e.getKeyCode() == 10) {
                this.sear = true;
                this.selectMod();
            }
        } else {
            this.leftListModel.addElement(Read.getTextwith("seite2", "searchn"));
            this.leftList.setEnabled(false);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object s = e.getSource();
        if (s == this.selectArrow) {
            this.selectMod();
        } else if (s == this.removeArrow) {
            this.removeMod();
        } else if (s == this.importButton) {
            this.importMod();
        } else if (s == this.restoreButton) {
            if (this.restoreButton.isEnabled()) {
                this.restore();
            }
        } else if (s == this.helpButton) {
            new Browser(String.valueOf(Read.getTextwith("installer", "website")) + "/faq.php");
        } else if (s == this.linkButton) {
            if (this.linkButton.isEnabled()) {
                new Browser(this.hyperlink);
            }
        } else if (s == this.sourceButton) {
            if (this.sourceButton.isEnabled()) {
                new Browser(this.website);
            }
        } else if (s == this.picture) {
            if (this.importmod) {
                this.importMod();
            } else if (this.online) {
                new Fullscreen(this.modtexts, this.modtext.getText(), this.proposal);
            }
        } else if (s == this.exitButton) {
            System.exit(0);
        } else if (s == this.minimizeButton) {
            this.setState(1);
        }
        int i = 0;
        while (i < this.ratIcons.length) {
            if (e.getSource() == this.ratIcons[i]) {
                if (this.rating == (double)i) {
                    this.setRating(this.proz, false);
                    this.manual = false;
                    this.rating = -1.0;
                } else {
                    this.setRating(i + 1, true);
                    this.manual = true;
                    this.rating = i;
                    try {
                        String body = "Mod=" + this.leftList.getSelectedValue().toString() + "&Version=" + this.mcVersion + "&Rating=" + String.valueOf(i + 1);
                        new Download().post("http://www.minecraft-installer.de/ratemod.php", body);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        Object s = e.getSource();
        int i = 0;
        while (i < this.ratIcons.length) {
            if (s == this.ratIcons[i] && !this.manual) {
                this.setRating(i + 1, true);
            }
            ++i;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        Object s = e.getSource();
        int i = 0;
        while (i < this.ratIcons.length) {
            if (s == this.ratIcons[i]) {
                if (this.manual) {
                    this.setRating(this.rating + 1.0, true);
                } else {
                    this.setRating(this.proz, false);
                }
            }
            ++i;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Object s = e.getSource();
        if (s == this.leftList) {
            this.leftListItemSelected(e);
        } else if (s == this.rightList) {
            this.rightListItemSelected(e);
        } else if (s == this.nextButton && this.nextButton.isEnabled()) {
            this.startInstallation();
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object s = e.getSource();
        if (s == this.ChVers) {
            this.changeVersion();
        }
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        if (this.tabbedPane.isEnabled()) {
            if (this.tabbedPane.getSelectedIndex() == 0) {
                this.setModloader();
            } else {
                this.setForge();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.enterSearchText(e);
    }
}

