/*
 * Decompiled with CFR 0.152.
 */
package org.spout.nbt.holder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.spout.nbt.ListTag;
import org.spout.nbt.Tag;
import org.spout.nbt.holder.Field;
import org.spout.nbt.holder.FieldUtils;

public class ListField<T>
implements Field<List<T>> {
    private final Field<T> backingField;

    public ListField(Field<T> field) {
        this.backingField = field;
    }

    @Override
    public List<T> getValue(Tag<?> tag) throws IllegalArgumentException {
        ListTag listTag = FieldUtils.checkTagCast(tag, ListTag.class);
        ArrayList<T> result = new ArrayList<T>();
        Iterator iterator = listTag.getValue().iterator();
        while (iterator.hasNext()) {
            Tag element = (Tag)iterator.next();
            result.add(this.backingField.getValue(element));
        }
        return result;
    }

    @Override
    public Tag<?> getValue(String name, List<T> value) {
        ArrayList tags = new ArrayList();
        Class tagClazz = Tag.class;
        for (T element : value) {
            Tag<?> tag = this.backingField.getValue("", element);
            tagClazz = tag.getClass();
            tags.add(tag);
        }
        return new ListTag<Tag>(name, tagClazz, tags);
    }
}

