/*
 * Decompiled with CFR 0.152.
 */
package org.spout.nbt.regionfile;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.InflaterInputStream;
import org.spout.nbt.Tag;
import org.spout.nbt.stream.NBTInputStream;

public class SimpleRegionFileReader {
    private static int EXPECTED_VERSION = 1;

    /*
     * Loose catch block
     */
    public static List<Tag<?>> readFile(File f) {
        RandomAccessFile raf;
        block23: {
            try {
                raf = new RandomAccessFile(f, "r");
            }
            catch (FileNotFoundException e) {
                return null;
            }
            int version = raf.readInt();
            if (version == EXPECTED_VERSION) break block23;
            try {
                raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        int segmentSize = raf.readInt();
        int segmentMask = (1 << segmentSize) - 1;
        int entries = raf.readInt();
        ArrayList list = new ArrayList(entries);
        int[] blockSegmentStart = new int[entries];
        int[] blockActualLength = new int[entries];
        int i = 0;
        while (i < entries) {
            blockSegmentStart[i] = raf.readInt();
            blockActualLength[i] = raf.readInt();
            ++i;
        }
        i = 0;
        while (i < entries) {
            if (blockActualLength[i] == 0) {
                list.add(null);
            } else {
                byte[] data = new byte[blockActualLength[i]];
                raf.seek(blockSegmentStart[i] << segmentSize);
                raf.readFully(data);
                ByteArrayInputStream in = new ByteArrayInputStream(data);
                InflaterInputStream iis = new InflaterInputStream(in);
                NBTInputStream ns = new NBTInputStream(iis, false);
                try {
                    Tag t = ns.readTag();
                    list.add(t);
                }
                catch (IOException ioe) {
                    list.add(null);
                }
                try {
                    ns.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++i;
        }
        ArrayList arrayList = list;
        try {
            raf.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayList;
        catch (IOException ioe) {
            try {
                raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
            catch (Throwable throwable) {
                try {
                    raf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

