/*
 * Decompiled with CFR 0.152.
 */
package org.spout.nbt.holder;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.spout.nbt.CompoundTag;
import org.spout.nbt.Tag;
import org.spout.nbt.holder.Field;
import org.spout.nbt.holder.FieldHolder;
import org.spout.nbt.holder.FieldUtils;

public class FieldHolderField<T extends FieldHolder>
implements Field<T> {
    private final Class<T> type;
    private final Constructor<T> typeConst;

    public FieldHolderField(Class<T> type) {
        this.type = type;
        try {
            this.typeConst = type.getConstructor(new Class[0]);
            this.typeConst.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError("Type must have zero-arg constructor!");
        }
    }

    @Override
    public T getValue(Tag<?> rawTag) throws IllegalArgumentException {
        CompoundTag tag = FieldUtils.checkTagCast(rawTag, CompoundTag.class);
        FieldHolder value = null;
        try {
            value = (FieldHolder)this.typeConst.newInstance(new Object[0]);
            value.load(tag);
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return (T)value;
    }

    @Override
    public Tag<?> getValue(String name, T value) {
        return new CompoundTag(name, ((FieldHolder)value).save());
    }
}

