/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.Error;
import installer.Fullscreen;
import installer.Import;
import installer.Install;
import installer.MCVersions;
import installer.MenuGUI;
import installer.Modinfo;
import installer.OP;
import installer.OperatingSystem;
import installer.Postrequest;
import installer.Read;
import installer.Start;
import installer.Survey;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.filechooser.FileNameExtensionFilter;

public class Menu
extends MenuGUI {
    private static final long serialVersionUID = 1L;
    public static boolean isModloader = true;
    private String mcVersion = Start.mcVersion;
    private String modx = "";
    private boolean manual = false;
    private boolean importmod = false;
    private boolean searchfocus = false;
    private boolean ist = false;
    private double proz = 0.0;
    private double rating = 0.0;
    private int modID = -1;
    private ArrayList<Modinfo> modlArrL = new ArrayList();
    private ArrayList<Modinfo> forgeArrL = new ArrayList();
    private ArrayList<Modinfo> proposals = new ArrayList();
    private Modinfo[] modtexts = Start.modtexts;
    private Modinfo[] moddownloads = Start.moddownloads;
    private JList<String> leftList;
    private DefaultListModel<String> leftListModel;
    private Thread bart = null;
    private Thread picThread = null;

    public Menu() {
        this.GUI();
        this.setVisible(true);
        this.load();
        if (Start.online) {
            new Survey();
        }
    }

    private void load() {
        if (Start.online) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Menu.this.picture.setIcon(new ImageIcon(this.getClass().getResource("src/wait.gif")));
                    Menu.this.tabbedPane.setEnabled(false);
                    Menu.this.modlArrL.clear();
                    Menu.this.forgeArrL.clear();
                    OP.del(new File(Start.sport, "Import"));
                    try {
                        int k = 0;
                        while (k < Menu.this.moddownloads.length) {
                            if (Menu.this.moddownloads[k].getMC().equals(Menu.this.mcVersion) && Menu.this.moddownloads[k].getCat() == 0) {
                                Menu.this.modlArrL.add(Menu.this.moddownloads[k]);
                            } else if (Menu.this.moddownloads[k].getMC().equals(Menu.this.mcVersion) && Menu.this.moddownloads[k].getCat() == 3) {
                                Menu.this.forgeArrL.add(Menu.this.moddownloads[k]);
                            }
                            ++k;
                        }
                    }
                    catch (Exception ex) {
                        new Error(OP.getError(ex));
                    }
                    if (Menu.this.forgeArrL.size() > 0) {
                        Menu.this.tabbedPane.setEnabled(true);
                    }
                    if (Menu.this.forgeArrL.size() >= Menu.this.modlArrL.size()) {
                        Menu.this.setForge();
                    } else {
                        Menu.this.setModloader();
                    }
                }
            });
        } else {
            this.setOffline(true);
        }
    }

    private void setOffline(boolean off) {
        if (off) {
            Start.online = false;
            this.leftListMModel.removeAllElements();
            this.leftListFModel.removeAllElements();
            this.rightListModel.removeAllElements();
            this.searchInput.setEnabled(false);
            this.selectArrow.setEnabled(false);
            this.setImport(true);
        } else {
            Start.online = true;
            this.searchInput.setEnabled(true);
            this.selectArrow.setEnabled(true);
        }
    }

    private void setModloader() {
        this.resetSelection();
        this.leftListModel = this.leftListMModel;
        this.leftList = this.leftListM;
        isModloader = true;
        this.proposals = this.modlArrL;
        this.tabbedPane.setSelectedIndex(0);
        this.sortOutInstalledMods();
        this.ist = true;
    }

    private void setForge() {
        this.resetSelection();
        this.leftListModel = this.leftListFModel;
        this.leftList = this.leftListF;
        isModloader = false;
        this.proposals = this.forgeArrL;
        this.tabbedPane.setSelectedIndex(1);
        this.sortOutInstalledMods();
        this.ist = true;
    }

    private void resetSelection() {
        for (Modinfo prop : this.proposals) {
            prop.setSelect(false);
        }
    }

    private void sortOutInstalledMods() {
        String Mode = "Modloader";
        if (!isModloader) {
            Mode = "Forge";
        }
        if (OP.optionReader("lastmc").equals(this.mcVersion) && OP.optionReader("lastmode").equals(Mode)) {
            try {
                String alastm = OP.optionReader("lastmods");
                String[] stringArray = alastm.split(";;");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String laste = stringArray[n2];
                    for (Modinfo prop : this.proposals) {
                        if (!laste.matches("[0-9]+") || Integer.parseInt(laste) != prop.getID()) continue;
                        prop.setSelect(true);
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                new Error(OP.getError(e));
            }
        }
        this.updateLists();
        this.loadTexts();
    }

    public void updateLists() {
        this.nextButton.setEnabled(false);
        if (this.leftListModel != null) {
            this.leftListModel.removeAllElements();
        }
        this.rightListModel.removeAllElements();
        this.searchInput.reset();
        if (this.leftList != null) {
            this.leftList.setEnabled(true);
            this.leftList.requestFocusInWindow();
        }
        for (Modinfo prop : this.proposals) {
            if (prop.getSelect()) {
                this.rightListModel.addElement(prop.getName());
                this.nextButton.setEnabled(true);
                continue;
            }
            this.leftListModel.addElement(prop.getName());
        }
        new Thread(){

            @Override
            public void run() {
                File impo;
                File impf = new File(Start.sport, "Import");
                String mode = "Forge";
                if (isModloader) {
                    mode = "Modloader";
                }
                if (OP.optionReader("lastmc").equals(Menu.this.mcVersion) && OP.optionReader("lastmode").equals(mode) && (impo = new File(Start.sport, "Importo")).exists()) {
                    try {
                        OP.rename(impo, impf);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (impf.exists()) {
                    File[] imports;
                    File[] fileArray = imports = impf.listFiles();
                    int n = imports.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name;
                        File modi = fileArray[n2];
                        if (!isModloader) {
                            if (modi.isFile()) {
                                name = modi.getName().substring(0, modi.getName().lastIndexOf("."));
                                Menu.this.rightListModel.addElement("+ " + name);
                                Menu.this.nextButton.setEnabled(true);
                            }
                        } else if (modi.isDirectory()) {
                            name = modi.getName();
                            Menu.this.rightListModel.addElement("+ " + name);
                            Menu.this.nextButton.setEnabled(true);
                        }
                        ++n2;
                    }
                }
            }
        }.start();
        if (this.bart != null) {
            this.bart.interrupt();
        }
        this.bart = new Thread(){

            @Override
            public void run() {
                String zeile = "";
                for (Modinfo prop : Menu.this.proposals) {
                    if (!prop.getSelect()) continue;
                    zeile = String.valueOf(zeile) + String.valueOf(prop.getID()) + ";;";
                }
                if (zeile.length() > 1) {
                    zeile = zeile.substring(0, zeile.length() - 2);
                }
                String res = "";
                try {
                    res = new Postrequest("https://www.minecraft-installer.de/api/compGet.php", "Mods=" + zeile).toString();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!res.equals("")) {
                    int val = -1;
                    try {
                        val = (int)Double.parseDouble(res);
                    }
                    catch (Exception e) {
                        val = -1;
                    }
                    if (val == -1) {
                        Menu.this.ratingBar.setVisible(false);
                    } else {
                        Menu.this.ratingBar.setVisible(true);
                        Menu.this.ratingBar.setValue(val);
                    }
                } else {
                    Menu.this.ratingBar.setVisible(false);
                }
            }
        };
        this.bart.start();
    }

    private void loadTexts() {
        if (this.leftListModel.isEmpty()) {
            if (!this.rightListModel.isEmpty()) {
                this.rightList.setSelectedIndex(0);
                this.setInfoText((String)this.rightListModel.get(0));
            }
        } else {
            this.leftList.setSelectedIndex(0);
            this.setInfoText(this.leftListModel.get(0));
        }
    }

    public void changeVersion() {
        this.ist = false;
        this.resetSelection();
        this.mcVersLabel.setText("Minecraft " + Start.mcVersion);
        this.modDescPane.setText(Read.getTextwith("Menu", "wait"));
        this.leftListMSP.getVerticalScrollBar().setValue(0);
        this.leftListFSP.getVerticalScrollBar().setValue(0);
        this.mcVersion = Start.mcVersion;
        this.load();
    }

    private void setInfoText(final String modname) {
        if (modname == null) {
            return;
        }
        boolean newt = false;
        if (modname.equals(this.modNameLabel.getText())) {
            newt = true;
        } else {
            this.picture.setIcon(new ImageIcon(this.getClass().getResource("src/wait.gif")));
        }
        this.setImport(false);
        this.modNameLabel.setText(modname);
        Modinfo[] modinfoArray = this.modtexts;
        int n = this.modtexts.length;
        int n2 = 0;
        while (n2 < n) {
            Modinfo modt = modinfoArray[n2];
            if (modt.getName().equals(modname)) {
                try {
                    String inh = modt.getText();
                    this.modID = modt.getID();
                    this.website = modt.getSource();
                    this.YouTube = modt.getYouTube();
                    this.hyperlink = String.valueOf(Read.getTextwith("installer", "website")) + "modinfo.php?modname=" + modname.replace(" ", "+");
                    String suche = this.searchInput.getText().replaceAll("\\(", "").replaceAll("\\)", "");
                    if (!suche.equals("") && suche.length() > 1) {
                        inh = inh.replaceAll("&auml;", "\u00e4");
                        inh = inh.replaceAll("&uuml;", "\u00fc");
                        inh = inh.replaceAll("&ouml;", "\u00f6");
                        inh = inh.replaceAll("&szlig;", "\u00df");
                        inh = inh.replaceAll("&quot;", "\"");
                        inh = inh.replaceAll("<m>", "");
                        inh = inh.replaceAll("</m>", "");
                        inh = inh.replaceAll("\\(", "");
                        inh = inh.replaceAll("\\)", "");
                        String rep = "";
                        Pattern word = Pattern.compile(suche, 66);
                        Matcher match = word.matcher(inh);
                        while (match.find()) {
                            rep = inh.substring(match.start(), match.end());
                        }
                        inh = inh.replaceAll("(?i)" + suche, "<m>" + rep + "</m>");
                        inh = inh.replaceAll("<m>", "<font style='background-color:#9C2717; color:white;'>");
                        inh = inh.replaceAll("</m>", "</font>");
                    }
                    if (!inh.startsWith("<html>")) {
                        inh = "<html><body>" + inh + "</body></html>";
                    }
                    this.modDescPane.setText(inh);
                    this.modDescPane.setCaretPosition(0);
                    this.manual = false;
                    Modinfo[] modinfoArray2 = this.moddownloads;
                    int n3 = this.moddownloads.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Modinfo modd = modinfoArray2[n4];
                        if (modd.getName().equals(modname) && modd.getMC().equals(this.mcVersion)) {
                            this.proz = modd.getRating();
                            if (this.proz > 6.5) {
                                this.topIcon.setIcon(new ImageIcon(this.getClass().getResource("src/top.png")));
                                this.topIcon.setVisible(true);
                            } else {
                                this.topIcon.setVisible(false);
                            }
                            if (modd.getDate() != null) {
                                long DAY_IN_MS = 86400000L;
                                Timestamp sevendago = new Timestamp(new Date(System.currentTimeMillis() - 7L * DAY_IN_MS).getTime());
                                Timestamp modst = modd.getDate();
                                if (modst.after(sevendago)) {
                                    this.topIcon.setIcon(new ImageIcon(this.getClass().getResource("src/new.png")));
                                    this.topIcon.setVisible(true);
                                }
                            } else {
                                this.topIcon.setVisible(false);
                            }
                            this.sizeLabel.setText(new OP().getSizeAsString(modd.getSize()));
                            this.setRating(this.proz, false);
                            break;
                        }
                        ++n4;
                    }
                }
                catch (Exception e) {
                    new Error(OP.getError(e));
                }
            }
            ++n2;
        }
        if (!newt) {
            if (this.picThread != null) {
                this.picThread.interrupt();
            }
            this.picThread = new Thread(){

                @Override
                public void run() {
                    try {
                        String url = "https://www.minecraft-installer.de/Dateien/BilderPre/" + modname + ".jpg";
                        url = url.replace(" ", "%20");
                        BufferedImage img = ImageIO.read(new URL(url));
                        Menu.this.picture.setIcon(new ImageIcon(img));
                        img.flush();
                        Menu.this.picture.setText("");
                    }
                    catch (Exception e) {
                        Menu.this.picture.setText(Read.getTextwith("Menu", "nopic"));
                        Menu.this.picture.setIcon(null);
                    }
                }
            };
            this.picThread.start();
        }
    }

    private void selectMods() {
        if (this.leftListModel.getSize() > 0 && this.leftList.isEnabled()) {
            List<Object> strlist = new ArrayList();
            strlist = this.leftList.getSelectedValuesList();
            for (String string : strlist) {
                for (Modinfo prop : this.proposals) {
                    if (!prop.getName().equals(string)) continue;
                    prop.setSelect(true);
                    String[] Requ = prop.getRequires();
                    if (Requ == null) continue;
                    String[] stringArray = prop.getRequires();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String req = stringArray[n2];
                        int ModID = Integer.parseInt(req);
                        for (Modinfo prop2 : this.proposals) {
                            if (prop2.getModID() != ModID) continue;
                            prop2.setSelect(true);
                        }
                        ++n2;
                    }
                }
            }
            this.updateLists();
            if (this.searchfocus) {
                this.searchInput.requestFocus();
            }
            this.searchfocus = false;
        }
    }

    private void removeMods() {
        if (this.rightListModel.getSize() > 0 && this.rightList.isEnabled()) {
            List strlist = new ArrayList();
            strlist = this.rightList.getSelectedValuesList();
            for (String listitem : strlist) {
                String name = String.valueOf(listitem);
                if (name.substring(0, 1).equals("+")) {
                    name = name.substring(2);
                    File importf = new File(Start.sport, "Import");
                    File importfn = new File(Start.sport, "Importn");
                    OP.del(new File(importf, String.valueOf(name) + ".jar"));
                    OP.del(new File(importf, name));
                    OP.del(new File(importfn, name));
                    continue;
                }
                this.leftList.setEnabled(true);
                Modinfo propx = null;
                ArrayList<Integer> reql = new ArrayList<Integer>();
                String namex = "";
                for (Modinfo prop : this.proposals) {
                    if (prop.getName().equals(listitem)) {
                        propx = prop;
                    }
                    if (prop.getRequires() == null || !prop.getSelect()) continue;
                    String[] stringArray = prop.getRequires();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        int ModID = Integer.parseInt(s);
                        reql.add(ModID);
                        namex = prop.getName();
                        ++n2;
                    }
                }
                if (!reql.contains(propx.getModID())) {
                    propx.setSelect(false);
                    continue;
                }
                boolean includes = false;
                for (String listitem2 : strlist) {
                    if (!namex.equals(listitem2)) continue;
                    propx.setSelect(false);
                    includes = true;
                }
                if (includes) continue;
                JOptionPane.showMessageDialog(null, String.valueOf(Read.getTextwith("Menu", "t15")) + namex + Read.getTextwith("Menu", "t16") + propx.getName() + "\".", Read.getTextwith("Menu", "t17"), 0);
            }
            this.updateLists();
        }
    }

    private void startInstallation() {
        try {
            ArrayList<Modinfo> selected = new ArrayList<Modinfo>();
            for (Modinfo prop : this.proposals) {
                if (!prop.getSelect()) continue;
                selected.add(prop);
            }
            this.dispose();
            new Install(selected, isModloader);
        }
        catch (Exception ex) {
            new Error(String.valueOf(OP.getError(ex)) + "\n\nErrorcode: S2x09");
        }
    }

    private void importMod() {
        this.setImport(true);
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(true);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Mods (.jar, .zip)", "jar", "zip");
        chooser.setFileFilter(filter);
        int rueckgabeWert = chooser.showOpenDialog(this);
        if (rueckgabeWert == 0) {
            File[] fileArray = chooser.getSelectedFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File modfile = fileArray[n2];
                new Import(modfile, (MenuGUI)this);
                ++n2;
            }
        }
    }

    public void setImport(boolean yes) {
        if (yes) {
            this.picture.setIcon(new ImageIcon(this.getClass().getResource("src/importbig.png")));
            if (isModloader) {
                this.modNameLabel.setText(Read.getTextwith("Menu", "importmh"));
                this.modDescPane.setText(Read.getTextwith("Menu", "importm"));
            } else {
                this.modNameLabel.setText(Read.getTextwith("Menu", "importfh"));
                this.modDescPane.setText(Read.getTextwith("Menu", "importf"));
            }
        }
        this.modDescPane.setCaretPosition(0);
        this.importmod = yes;
        this.modinstWebLnk.setVisible(!yes);
        this.modVersionL.setVisible(yes);
        this.topIcon.setVisible(!yes);
        this.videoButton.setVisible(!yes);
        JLabel[] jLabelArray = this.ratIcons;
        int n = this.ratIcons.length;
        int n2 = 0;
        while (n2 < n) {
            JLabel ic = jLabelArray[n2];
            ic.setVisible(!yes);
            ++n2;
        }
    }

    private void restore() {
        OP.del(new File(Start.mineord, "versions/Modinstaller"));
        try {
            File modsport = new File(Start.mineord, "versions/Modinstaller");
            OP.copy(new File(Start.sport, "Backup/Modinstaller.jar"), new File(modsport, "Modinstaller.jar"));
            OP.copy(new File(Start.sport, "Backup/Modinstaller.json"), new File(modsport, "Modinstaller.json"));
            OP.copy(new File(Start.sport, "Backup/mods"), new File(Start.mineord, "mods"));
            JOptionPane.showMessageDialog(null, Read.getTextwith("Menu", "restore"), Read.getTextwith("Menu", "restoreh"), 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OP.optionWriter("lastmods", OP.optionReader("slastmods"));
        OP.optionWriter("slastmods", OP.optionReader("n/a"));
        OP.optionWriter("lastmc", OP.optionReader("slastmc"));
        OP.optionWriter("slastmc", OP.optionReader("n/a"));
        OP.optionWriter("lastmode", OP.optionReader("slastmode"));
        OP.optionWriter("slastmode", OP.optionReader("n/a"));
        this.restoreButton.setEnabled(false);
    }

    private void setRating(double stars, boolean manual) {
        JLabel[] jLabelArray = this.ratIcons;
        int n = this.ratIcons.length;
        int n2 = 0;
        while (n2 < n) {
            JLabel s = jLabelArray[n2];
            if (stars > 0.75) {
                if (manual) {
                    s.setIcon(new ImageIcon(this.getClass().getResource("src/star1b.png")));
                } else {
                    s.setIcon(new ImageIcon(this.getClass().getResource("src/star1.png")));
                }
            } else if (stars > 0.25) {
                s.setIcon(new ImageIcon(this.getClass().getResource("src/star05.png")));
            } else {
                s.setIcon(new ImageIcon(this.getClass().getResource("src/star0.png")));
            }
            stars -= 1.0;
            ++n2;
        }
    }

    private void enterSearchText(KeyEvent e) {
        int si = this.leftList.getSelectedIndex();
        if (e.getKeyCode() == 40) {
            this.leftList.setSelectedIndex(si + 1);
            this.setInfoText(this.leftList.getSelectedValue().toString());
        } else if (e.getKeyCode() == 38) {
            if (si != 0) {
                this.leftList.setSelectedIndex(si - 1);
                this.setInfoText(this.leftList.getSelectedValue().toString());
            }
        } else if (e.getKeyCode() == 10 || e.getKeyCode() == 39) {
            this.searchfocus = true;
            this.selectMods();
        } else {
            String modname;
            this.leftListModel.removeAllElements();
            String needle = this.searchInput.getText().toLowerCase().replace(" ", "");
            for (Modinfo prop : this.proposals) {
                modname = prop.getName().toLowerCase().replace(" ", "");
                if (!modname.startsWith(needle) || prop.getSelect()) continue;
                this.leftListModel.addElement(prop.getName());
            }
            for (Modinfo prop : this.proposals) {
                modname = prop.getName().toLowerCase().replace(" ", "");
                if (!modname.contains(needle) || modname.startsWith(needle) || prop.getSelect()) continue;
                this.leftListModel.addElement(prop.getName());
            }
            block2: for (Modinfo prop : this.proposals) {
                Modinfo[] modinfoArray = this.modtexts;
                int n = this.modtexts.length;
                int n2 = 0;
                while (n2 < n) {
                    Modinfo info = modinfoArray[n2];
                    if (info.getName().equals(prop.getName())) {
                        String modtext = info.getText().toLowerCase().replace(" ", "");
                        modtext = modtext.replace("&auml;", "\u00e4");
                        modtext = modtext.replace("&uuml;", "\u00fc");
                        modtext = modtext.replace("&ouml;", "\u00f6");
                        modtext = modtext.replace("&szlig;", "\u00df");
                        if ((modtext = modtext.replace("&quot;", "\"")).contains(needle) && !this.leftListModel.contains(prop.getName()) && !this.rightListModel.contains(prop.getName())) {
                            this.leftListModel.addElement(prop.getName());
                            continue block2;
                        }
                    }
                    ++n2;
                }
            }
            if (this.leftListModel.size() > 0) {
                this.modx = this.leftListModel.getElementAt(0).toString();
                this.setInfoText(this.modx);
                this.leftList.setSelectedIndex(0);
                this.leftListMSP.getVerticalScrollBar().setValue(0);
                this.leftListFSP.getVerticalScrollBar().setValue(0);
                this.leftList.setEnabled(true);
            } else {
                this.leftListModel.addElement(Read.getTextwith("Menu", "searchn"));
                this.leftList.setEnabled(false);
            }
        }
    }

    private void showTextLeft(int index) {
        if (this.leftList.isEnabled() && index > -1 && index < this.leftListModel.size()) {
            String Auswahl = this.leftListModel.getElementAt(index);
            if (!this.modNameLabel.getText().equals(Auswahl)) {
                this.setInfoText(Auswahl);
            }
        }
    }

    private void showTextRight(int index) {
        if (this.rightList.isEnabled() && index > -1 && index < this.rightListModel.size()) {
            final String Auswahl = (String)this.rightListModel.getElementAt(index);
            if (Auswahl.substring(0, 1).equals("+")) {
                this.modNameLabel.setText("Loading Mod...");
                this.picture.setIcon(new ImageIcon(this.getClass().getResource("src/wait.gif")));
                new Thread(){

                    @Override
                    public void run() {
                        new Import(Auswahl.substring(2), (MenuGUI)Menu.this);
                    }
                }.start();
            } else if (!this.modNameLabel.getText().equals(Auswahl)) {
                this.setInfoText(Auswahl);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Object s = e.getSource();
        if (s == this.selectArrow) {
            this.selectMods();
        } else if (s == this.removeArrow) {
            this.removeMods();
        } else if (s == this.importButton) {
            this.importMod();
        } else if (s == this.restoreButton) {
            if (this.restoreButton.isEnabled()) {
                this.restore();
            }
        } else if (s == this.helpButton) {
            OperatingSystem.openLink(String.valueOf(Read.getTextwith("installer", "website")) + "faq.php");
        } else if (s == this.videoButton) {
            OperatingSystem.openLink(this.YouTube);
        } else if (s == this.modinstWebLnk) {
            if (this.modinstWebLnk.isEnabled()) {
                OperatingSystem.openLink(this.hyperlink);
            }
        } else if (s == this.devWebLnk) {
            if (this.devWebLnk.isEnabled()) {
                OperatingSystem.openLink(this.website);
            }
        } else if (s == this.picture) {
            if (this.importmod) {
                this.importMod();
            } else if (Start.online) {
                new Fullscreen(this.modtexts, this.modNameLabel.getText(), this.proposals);
            }
        } else if (s == this.exitButton) {
            System.exit(0);
        } else if (s == this.minButton) {
            this.setState(1);
        } else if (s == this.nextButton && this.nextButton.isEnabled()) {
            this.startInstallation();
        } else if (s == this.mcVersLabel) {
            new MCVersions(this).setVisible(true);
        } else if (s == this.banner) {
            OperatingSystem.openLink("https://minecraft-installer.de/gewinnspiel/");
        }
        int i = 0;
        while (i < this.ratIcons.length) {
            if (e.getSource() == this.ratIcons[i]) {
                if (this.rating == (double)i) {
                    this.setRating(this.proz, false);
                    this.manual = false;
                    this.rating = -1.0;
                } else {
                    this.setRating(i + 1, true);
                    this.manual = true;
                    this.rating = i;
                    try {
                        String body = "modID=" + this.modID + "&rating=" + (this.rating + 1.0);
                        new Postrequest("https://www.minecraft-installer.de/api/modrating.php", body);
                    }
                    catch (Exception er) {
                        new Error(OP.getError(er));
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        Object s = e.getSource();
        int i = 0;
        while (i < this.ratIcons.length) {
            if (s == this.ratIcons[i] && !this.manual) {
                this.setRating(i + 1, true);
            }
            ++i;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        Object s = e.getSource();
        int i = 0;
        while (i < this.ratIcons.length) {
            if (s == this.ratIcons[i]) {
                if (this.manual) {
                    this.setRating(this.rating + 1.0, true);
                } else {
                    this.setRating(this.proz, false);
                }
            }
            ++i;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Object s = e.getSource();
        if (s == this.leftList) {
            JList list = (JList)e.getSource();
            this.showTextLeft(list.locationToIndex(e.getPoint()));
            if (e.getClickCount() == 2 || e.getButton() == 3) {
                this.selectMods();
            }
        } else if (s == this.rightList) {
            JList list = (JList)e.getSource();
            this.showTextRight(list.locationToIndex(e.getPoint()));
            if (e.getClickCount() == 2 || e.getButton() == 3) {
                this.removeMods();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        if (this.tabbedPane.isEnabled() && arg0.getSource() == this.tabbedPane && this.ist) {
            if (this.tabbedPane.getSelectedIndex() == 0) {
                this.setModloader();
            } else {
                this.setForge();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int k = e.getKeyCode();
        if (e.getSource() == this.searchInput) {
            this.enterSearchText(e);
        } else if (e.getSource() == this.leftList) {
            if (k == 10 || k == 39) {
                this.selectMods();
            } else if (k != 17) {
                this.showTextLeft(this.leftList.getSelectedIndex());
            }
        } else if (e.getSource() == this.rightList) {
            if (k == 10 || k == 37 || k == 127 || k == 8) {
                this.removeMods();
            } else if (k != 17) {
                this.showTextRight(this.rightList.getSelectedIndex());
            }
        }
    }
}

