/*
 * Decompiled with CFR 0.152.
 */
package installer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import installer.Artifact;
import installer.Compress;
import installer.Downloader;
import installer.Downloadstate;
import installer.Error;
import installer.Extract;
import installer.InstallGUI;
import installer.Modinfo;
import installer.OP;
import installer.OperatingSystem;
import installer.Read;
import installer.Start;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.swing.ImageIcon;
import org.spout.nbt.CompoundMap;
import org.spout.nbt.CompoundTag;
import org.spout.nbt.ListTag;
import org.spout.nbt.StringTag;
import org.spout.nbt.Tag;
import org.spout.nbt.stream.NBTInputStream;
import org.spout.nbt.stream.NBTOutputStream;

public class Install
extends InstallGUI {
    private static final long serialVersionUID = 1L;
    private String mcVersion = Start.mcVersion;
    private boolean online = Start.online;
    private double mainVal = 0.0;
    private File modsport = new File(Start.mineord, "versions/Modinstaller");
    private ArrayList<Modinfo> mods;
    private boolean isModloader;
    private static FileInputStream fis;
    private static final String PACK_NAME = ".pack.xz";
    public static String errors;
    private RandomAccessFile f;

    static {
        errors = "";
    }

    public Install(ArrayList<Modinfo> mods, boolean isModloader) {
        this.mods = mods;
        this.isModloader = isModloader;
        this.GUI();
        this.changeSymbols(false);
        this.installation();
    }

    public void installation() {
        new Thread(){

            @Override
            public void run() {
                try {
                    Install install = Install.this;
                    double d = install.mainVal + 1.0;
                    install.mainVal = d;
                    Install.this.mainState(d);
                    Install.this.mainBarInf.setText(Read.getTextwith("Install", "main1"));
                    try {
                        Install.this.detBarInf.setText(Read.getTextwith("Install", "def1"));
                        Install.this.stateIcon.setIcon(new ImageIcon(this.getClass().getResource("src/restore2.png")));
                        OP.del(new File(Start.sport, "Backup"));
                        OP.copy(Install.this.modsport, new File(Start.sport, "Backup"));
                        Install install2 = Install.this;
                        double d2 = install2.mainVal + 2.0;
                        install2.mainVal = d2;
                        Install.this.mainState(d2);
                        OP.copy(new File(Start.mineord, "mods"), new File(Start.sport, "Backup/mods"));
                    }
                    catch (Exception e) {
                        Install install3 = Install.this;
                        double d3 = install3.mainVal + 2.0;
                        install3.mainVal = d3;
                        Install.this.mainState(d3);
                        Install.this.detBarInf.setText("Errorocde: S3x0a: " + String.valueOf(e));
                        errors = String.valueOf(errors) + OP.getError(e) + " Errorcode: S3x0a\n\n";
                    }
                    Install install4 = Install.this;
                    double d4 = install4.mainVal + 2.0;
                    install4.mainVal = d4;
                    Install.this.mainState(d4);
                    Install.this.detBarInf.setText(Read.getTextwith("Install", "def2"));
                    OP.del(new File(Start.sport, "Result"));
                    OP.del(new File(Start.sport, "Original"));
                    OP.del(new File(Start.mineord, "mods"));
                    OP.del(new File(Start.mineord, "coremods"));
                    OP.del(new File(Start.mineord, "config"));
                    OP.del(Install.this.modsport);
                    Install install5 = Install.this;
                    double d5 = install5.mainVal + 1.0;
                    install5.mainVal = d5;
                    Install.this.mainState(d5);
                    Install.this.detBarInf.setText(Read.getTextwith("Install", "def3"));
                    OP.makedirs(new File(Start.sport, "Result"));
                    OP.makedirs(new File(Start.sport, "Backup"));
                    OP.makedirs(Install.this.modsport);
                    File mcVersionFolder = new File(Start.mineord, "versions/" + Install.this.mcVersion);
                    mcVersionFolder.mkdirs();
                    Install install6 = Install.this;
                    double d6 = install6.mainVal + 1.0;
                    install6.mainVal = d6;
                    Install.this.mainState(d6);
                    if (Install.this.online) {
                        File jarFile;
                        Install.this.mainBarInf.setText(Read.getTextwith("Install", "main2"));
                        File jsonFile = new File(Start.mineord, "versions/" + Install.this.mcVersion + "/" + Install.this.mcVersion + ".json");
                        if (!jsonFile.exists()) {
                            Install.this.detBarInf.setText(Read.getTextwith("Install", "def4"));
                            new Downloader("https://files.minecraft-mods.de/installer/MCModloader/" + Install.this.mcVersion + ".json", jsonFile).run();
                        }
                        if (!(jarFile = new File(Start.mineord, "versions/" + Install.this.mcVersion + "/" + Install.this.mcVersion + ".jar")).exists()) {
                            Install.this.stateIcon.setIcon(new ImageIcon(this.getClass().getResource("src/download.png")));
                            Install.this.detBarInf.setText(Read.getTextwith("Install", "def5"));
                            Downloader dow = new Downloader("https://files.minecraft-mods.de/installer/MCModloader/" + Install.this.mcVersion + ".jar", jarFile);
                            Thread t = new Thread(new Downloadstate(dow));
                            t.start();
                            dow.run();
                            t.interrupt();
                        }
                    }
                    Install install7 = Install.this;
                    double d7 = install7.mainVal + 2.0;
                    install7.mainVal = d7;
                    Install.this.mainState(d7);
                    Install.this.detBarInf.setText(Read.getTextwith("Install", "def6"));
                    OP.copy(mcVersionFolder, Install.this.modsport);
                    File newJson = new File(Install.this.modsport, "Modinstaller.json");
                    OP.rename(new File(Install.this.modsport, String.valueOf(Install.this.mcVersion) + ".jar"), new File(Install.this.modsport, "Modinstaller.jar"));
                    OP.rename(new File(Install.this.modsport, String.valueOf(Install.this.mcVersion) + ".json"), newJson);
                    Install install8 = Install.this;
                    double d8 = install8.mainVal + 1.0;
                    install8.mainVal = d8;
                    Install.this.mainState(d8);
                    Install.this.mainBarInf.setText(Read.getTextwith("Install", "main3"));
                    if (newJson.exists()) {
                        Install.this.installLibraries(newJson);
                    }
                    if (Install.this.isModloader) {
                        Install.this.mainBarInf.setText(Read.getTextwith("Install", "main4"));
                        Install.this.detBarInf.setText("");
                        Install.this.stateIcon.setIcon(new ImageIcon(this.getClass().getResource("src/extract.png")));
                        new Extract(new File(Install.this.modsport, "Modinstaller.jar"), new File(Start.sport, "Result"));
                        Install install9 = Install.this;
                        double d9 = install9.mainVal + 10.0;
                        install9.mainVal = d9;
                        Install.this.mainState(d9);
                    }
                    Install.this.writeLog();
                }
                catch (Exception ex) {
                    Install.this.detBarInf.setText("Errorcode: S3x01: " + String.valueOf(ex));
                    errors = String.valueOf(errors) + OP.getError(ex) + " Errorcode: S3x01\n\n";
                }
                if (Install.this.online) {
                    Install.this.mainBarInf.setText(Read.getTextwith("Install", "main5"));
                    Install.this.downloadMods();
                }
                Install.this.mainBarInf.setText(Read.getTextwith("Install", "main6"));
                Install.this.importMods();
                Install install = Install.this;
                double d = install.mainVal + 10.0;
                install.mainVal = d;
                Install.this.mainState(d);
                Install.this.stateIcon.setIcon(new ImageIcon(this.getClass().getResource("src/install.png")));
                Install.this.detBarInf.setText("");
                if (Install.this.isModloader) {
                    Install.this.mainBarInf.setText(Read.getTextwith("Install", "main7"));
                    Install.this.stateIcon.setIcon(new ImageIcon(this.getClass().getResource("src/compress.png")));
                    new Compress(new File(Start.sport, "Result"), new File(Install.this.modsport, "Modinstaller.jar"));
                    Install install10 = Install.this;
                    double d10 = install10.mainVal + 5.0;
                    install10.mainVal = d10;
                    Install.this.mainState(d10);
                }
                Install.this.mainBarInf.setText(Read.getTextwith("Install", "main8"));
                Install.this.detBarInf.setText(Read.getTextwith("Install", "def7"));
                Install.this.setProfiles();
                Install install11 = Install.this;
                double d11 = install11.mainVal + 2.0;
                install11.mainVal = d11;
                Install.this.mainState(d11);
                if (Start.online) {
                    Install.this.modifyServerlist();
                }
                Install install12 = Install.this;
                double d12 = install12.mainVal + 2.0;
                install12.mainVal = d12;
                Install.this.mainState(d12);
                Install.this.detBarInf.setText(Read.getTextwith("Install", "def8"));
                File sound = new File(Start.mineord, "assets/indexes/" + Install.this.mcVersion + ".json");
                File soundc = new File(Start.mineord, "assets/indexes/Modinstaller.json");
                if (sound.exists()) {
                    try {
                        OP.copy(sound, soundc);
                    }
                    catch (Exception e) {
                        Install.this.detBarInf.setText("Errorocde: S3xSS: " + String.valueOf(e));
                        errors = String.valueOf(errors) + OP.getError(e) + " Errorcode: S3xSS\n\n";
                    }
                }
                Install install13 = Install.this;
                double d13 = install13.mainVal + 1.0;
                install13.mainVal = d13;
                Install.this.mainState(d13);
                Install.this.installcomplete = true;
                Install.this.changeSymbols(true);
                if (!errors.equals("")) {
                    new Error(errors);
                    Install.this.info.setText(Read.getTextwith("Install", "head2"));
                    Install.this.detBarInf.setText(Read.getTextwith("Install", "error"));
                }
            }
        }.start();
    }

    private void downloadMods() {
        try {
            OP.makedirs(new File(Start.sport, "Mods"));
            int i = 1;
            double add = 50.0 / (double)this.mods.size();
            for (Modinfo mod : this.mods) {
                this.detBarInf.setText(String.valueOf(Read.getTextwith("Install", "dow1a")) + mod.getName() + "</b>" + Read.getTextwith("Install", "dow1b"));
                this.mainBarInf.setText(String.valueOf(Read.getTextwith("Install", "main5")) + " (" + i + "/" + this.mods.size() + ")");
                this.stateIcon.setIcon(new ImageIcon(this.getClass().getResource("src/download.png")));
                ++i;
                String DownloadURL = "https://www.minecraft-installer.de/api/download3.php?id=" + mod.getID();
                File ZIPFile = new File(Start.sport, "Mods/" + mod.getID() + ".zip");
                File ZIPExtract = Start.mineord;
                if (this.isModloader) {
                    ZIPExtract = new File(Start.sport, "Result");
                }
                try {
                    if (ZIPFile.length() != (long)mod.getSize()) {
                        Downloader dow = new Downloader(DownloadURL, ZIPFile);
                        Thread t = new Thread(new Downloadstate(dow));
                        t.start();
                        dow.run();
                        t.interrupt();
                    }
                    this.mainState(this.mainVal += add * 0.8);
                    this.detBarInf.setText(String.valueOf(Read.getTextwith("Install", "dow2")) + mod.getName());
                    this.stateIcon.setIcon(new ImageIcon(this.getClass().getResource("src/extract.png")));
                    new Extract(ZIPFile, ZIPExtract);
                    this.mainState(this.mainVal += add * 0.2);
                }
                catch (Exception ex) {
                    this.detBarInf.setText("Errorocde: S3x04: " + String.valueOf(ex));
                    errors = String.valueOf(errors) + "Mod: " + mod.getName() + " " + this.mcVersion + "\nSource: " + DownloadURL + "\nFrom: " + ZIPFile.toString() + "\nTo: " + ZIPExtract.toString() + "\nException:\n" + OP.getError(ex) + "\nErrorcode: S3x04\n\n";
                }
            }
            if (!this.isModloader) {
                this.forgeInstallation();
                this.mainState(this.mainVal += 9.0);
                this.extraInstallation();
                this.mainState(this.mainVal += 1.0);
            }
        }
        catch (Exception ex) {
            this.detBarInf.setText("Errorocde: S3x04: " + String.valueOf(ex));
            errors = String.valueOf(errors) + OP.getError(ex) + " Errorcode: S3x04\n\n";
        }
    }

    private String getNativeString(JsonObject jo) {
        String add = null;
        boolean take = false;
        OperatingSystem os = OperatingSystem.getCurrentPlatform();
        try {
            if (jo.has("natives")) {
                String parch;
                JsonObject nat = jo.get("natives").getAsJsonObject();
                if (os == OperatingSystem.WINDOWS && nat.has("windows")) {
                    add = nat.get("windows").getAsString();
                } else if (os == OperatingSystem.OSX && nat.has("osx")) {
                    add = nat.get("osx").getAsString();
                } else if (os == OperatingSystem.LINUX && nat.has("linux")) {
                    add = nat.get("linux").getAsString();
                }
                String arch = "";
                if (os == OperatingSystem.WINDOWS) {
                    parch = System.getenv("PROCESSOR_ARCHITECTURE");
                    String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
                    arch = parch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64") ? "64" : "32";
                } else {
                    parch = System.getProperty("os.arch");
                    arch = parch.contains("64") ? "64" : "32";
                }
                if (add != null) {
                    add = add.replace("${arch}", arch);
                }
            }
            if (jo.has("rules")) {
                JsonArray ja = jo.get("rules").getAsJsonArray();
                for (JsonElement el : ja) {
                    JsonObject oso;
                    JsonObject obj = el.getAsJsonObject();
                    if (!obj.has("action")) continue;
                    String action = obj.get("action").getAsString();
                    if (action.equals("allow")) {
                        if (obj.has("os")) {
                            oso = obj.get("os").getAsJsonObject();
                            if (oso.has("name")) {
                                take = false;
                                String name = oso.get("name").getAsString();
                                if (os == OperatingSystem.WINDOWS) {
                                    if (!name.equals("windows")) continue;
                                    take = true;
                                    continue;
                                }
                                if (os == OperatingSystem.OSX) {
                                    if (!name.equals("osx")) continue;
                                    take = true;
                                    continue;
                                }
                                if (os != OperatingSystem.LINUX || !name.equals("linux")) continue;
                                take = true;
                                continue;
                            }
                            take = true;
                            continue;
                        }
                        take = true;
                        continue;
                    }
                    if (!action.equals("disallow") || !obj.has("os") || !(oso = obj.get("os").getAsJsonObject()).has("name")) continue;
                    String name2 = oso.get("name").getAsString();
                    if (os == OperatingSystem.WINDOWS) {
                        if (!name2.equals("windows")) continue;
                        take = false;
                        continue;
                    }
                    if (os == OperatingSystem.OSX) {
                        if (!name2.equals("osx")) continue;
                        take = false;
                        continue;
                    }
                    if (os != OperatingSystem.LINUX || !name2.equals("linux")) continue;
                    take = false;
                }
            } else {
                take = true;
            }
            if (!take) {
                add = "false";
            }
        }
        catch (Exception e) {
            this.detBarInf.setText("Errorcode: S3xna: " + String.valueOf(e));
            errors = String.valueOf(errors) + OP.getError(e) + " Errorcode: S3xna\n\n";
        }
        return add;
    }

    private void forgeInstallation() {
        this.mainBarInf.setText(Read.getTextwith("Install", "forge1"));
        new File(Start.sport, "Forge/").mkdirs();
        this.detBarInf.setText(Read.getTextwith("Install", "forge2"));
        this.stateIcon.setIcon(new ImageIcon(this.getClass().getResource("src/download.png")));
        File jsonFile = new File(Start.sport, "Forge/" + this.mcVersion + ".json");
        OP.del(jsonFile);
        new Downloader("https://files.minecraft-mods.de/installer/MCForge/versions/" + this.mcVersion + ".json", jsonFile).run();
        if (jsonFile.exists()) {
            this.installLibraries(jsonFile);
        }
        File jsonFile2 = new File(Start.mineord, "versions/Modinstaller/Modinstaller.json");
        try {
            OP.copy(jsonFile, jsonFile2);
        }
        catch (Exception e) {
            this.detBarInf.setText("Errorcode: S3xfo: " + String.valueOf(e));
            errors = String.valueOf(errors) + OP.getError(e) + " Errorcode: S3xfo\n\n";
        }
        this.detBarInf.setText(Read.getTextwith("Install", "forge3"));
        int i = 0;
        while (i < Start.allMCVersions.length) {
            if (Start.allMCVersions[i].getVersion().equals(this.mcVersion) && Start.allMCVersions[i].getStripMeta() == 1) {
                try {
                    File jar = new File(this.modsport, "Modinstaller.jar");
                    File resx = new File(Start.sport, "Resultx");
                    OP.del(resx);
                    new Extract(jar, resx, 50.0, 0.0);
                    OP.del(jar);
                    new Compress(resx, jar, 50.0, 50.0);
                    OP.del(resx);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    private void installLibraries(File jsonFile) {
        Gson gson = new Gson();
        String content = "";
        try {
            content = OP.Textreaders(jsonFile);
        }
        catch (Exception e) {
            this.detBarInf.setText("Errorcode: S3xli: " + String.valueOf(e));
            errors = String.valueOf(errors) + OP.getError(e) + " Errorcode: S3xli\n\n";
        }
        JsonObject main = gson.fromJson(content, JsonObject.class);
        main.addProperty("id", "Modinstaller");
        if (main.has("downloads")) {
            main.remove("downloads");
        }
        if (main.has("libraries") && this.online) {
            JsonArray arr = main.get("libraries").getAsJsonArray();
            double addi = 15.0 / (double)arr.size();
            int u = 1;
            for (JsonElement obj : arr) {
                this.mainBarInf.setText(String.valueOf(Read.getTextwith("Install", "lib1")) + u + "/" + arr.size() + ")");
                ++u;
                JsonObject jo = obj.getAsJsonObject();
                if (!jo.has("name")) continue;
                ArrayList<String> checksums = new ArrayList<String>();
                if (jo.has("checksums")) {
                    JsonArray ja = jo.get("checksums").getAsJsonArray();
                    for (JsonElement e : ja) {
                        checksums.add(e.getAsString());
                    }
                }
                String con = jo.get("name").getAsString();
                String add = this.getNativeString(jo);
                Artifact artifact = null;
                if (add != null) {
                    if (add.equals("false")) continue;
                    artifact = new Artifact(String.valueOf(con) + ":" + add);
                } else {
                    artifact = new Artifact(con);
                }
                String libURL = "https://libraries.minecraft.net/";
                if (jo.has("url")) {
                    libURL = jo.get("url").getAsString();
                }
                libURL = String.valueOf(libURL) + artifact.getPath();
                File libPath = artifact.getLocalPath(new File(Start.mineord, "libraries"));
                if (!libPath.exists()) {
                    this.detBarInf.setText(String.valueOf(Read.getTextwith("Install", "lib2")) + artifact.getDescriptor());
                    this.stateIcon.setIcon(new ImageIcon(this.getClass().getResource("src/download.png")));
                    Thread t2 = null;
                    try {
                        File packFile = new File(libPath.getParentFile(), String.valueOf(libPath.getName()) + PACK_NAME);
                        Downloader dow2 = new Downloader(String.valueOf(libURL) + PACK_NAME, packFile);
                        t2 = new Thread(new Downloadstate(dow2));
                        t2.start();
                        dow2.run();
                        t2.interrupt();
                        this.detBarInf.setText(String.valueOf(Read.getTextwith("Install", "lib3")) + artifact.getDescriptor());
                        this.stateIcon.setIcon(new ImageIcon(this.getClass().getResource("src/extract.png")));
                        this.f = new RandomAccessFile(packFile, "r");
                        byte[] b = new byte[(int)this.f.length()];
                        this.f.read(b);
                        this.f.close();
                        OP.unpackLibrary(libPath, b);
                        OP.del(packFile);
                    }
                    catch (Exception e2) {
                        t2.interrupt();
                        Thread t = null;
                        try {
                            Downloader dow = new Downloader(libURL, libPath);
                            t = new Thread(new Downloadstate(dow));
                            t.start();
                            dow.run();
                            t.interrupt();
                        }
                        catch (Exception e) {
                            t.interrupt();
                            this.detBarInf.setText("Errorcode: S3xli: " + String.valueOf(e));
                            errors = String.valueOf(errors) + con + ": " + "\n" + OP.getError(e) + " Errorcode: S3xli2\n\n";
                        }
                    }
                }
                if (libPath.exists()) {
                    try {
                        MessageDigest md = MessageDigest.getInstance("SHA1");
                        fis = new FileInputStream(libPath);
                        byte[] dataBytes = new byte[1024];
                        int nread = 0;
                        while ((nread = fis.read(dataBytes)) != -1) {
                            md.update(dataBytes, 0, nread);
                        }
                        byte[] mdbytes = md.digest();
                        StringBuffer sb = new StringBuffer("");
                        int i = 0;
                        while (i < mdbytes.length) {
                            sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
                            ++i;
                        }
                        File shafile = new File(libPath.getParentFile(), String.valueOf(libPath.getName()) + ".sha");
                        OP.Textwriter(shafile, sb.toString(), false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.mainState(this.mainVal += addi);
            }
        }
        try {
            Gson gson2 = new GsonBuilder().setPrettyPrinting().create();
            OP.Textwriter(jsonFile, gson2.toJson(main), false);
        }
        catch (IOException e) {
            this.detBarInf.setText("Errorocde: S3xJS: " + String.valueOf(e));
            errors = String.valueOf(errors) + OP.getError(e) + " Errorcode: S3xJS\n\n";
        }
    }

    private void extraInstallation() {
        try {
            String[] sp1;
            String sourceurl = "https://files.minecraft-mods.de/installer/Extra/downloadsrc.txt";
            File fileurl = new File(Start.sport, "downloadsrc.txt");
            new Downloader(sourceurl, fileurl).run();
            new OP();
            String cont = OP.Textreaders(fileurl);
            String[] stringArray = sp1 = cont.split(";;;;");
            int n = sp1.length;
            int n2 = 0;
            while (n2 < n) {
                String s1 = stringArray[n2];
                String[] sp2 = s1.split(";;");
                if (sp2[0].equals(this.mcVersion) || sp2[0].equals("all")) {
                    int i = 1;
                    while (i < sp2.length) {
                        File exra = new File(Start.sport, "Extra.zip");
                        Downloader dowf = new Downloader(sp2[i], exra);
                        try {
                            if (!dowf.isDownloadSizeEqual()) {
                                dowf.run();
                            }
                            try {
                                new Extract(exra, Start.mineord);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        ++i;
                    }
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void writeLog() {
        try {
            String mode = "Forge";
            if (this.isModloader) {
                mode = "Modloader";
            }
            OP.optionWriter("slastmc", OP.optionReader("lastmc"));
            OP.optionWriter("lastmc", this.mcVersion);
            OP.optionWriter("slastmode", OP.optionReader("lastmode"));
            OP.optionWriter("lastmode", mode);
            OP.optionWriter("changed", "true");
            if (this.mods.size() != 0) {
                OP.optionWriter("slastmods", OP.optionReader("lastmods"));
                String modn = "";
                for (Modinfo mod : this.mods) {
                    modn = String.valueOf(modn) + mod.getID() + ";;";
                }
                if (modn.endsWith(";;")) {
                    modn = modn.substring(0, modn.length() - 2);
                }
                OP.optionWriter("lastmods", modn);
            } else {
                OP.optionWriter("slastmods", "n/a");
                OP.optionWriter("lastmods", "n/a");
            }
        }
        catch (Exception e) {
            this.detBarInf.setText("Errorocde: S3x00: " + String.valueOf(e));
            errors = String.valueOf(errors) + OP.getError(e) + " Errorcode: S3x00\n\n";
        }
    }

    private void importMods() {
        File impf = new File(Start.sport, "Import");
        if (impf.exists()) {
            File modim;
            this.stateIcon.setIcon(new ImageIcon(this.getClass().getResource("src/import.png")));
            if (this.isModloader) {
                try {
                    File[] fileArray = impf.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        modim = fileArray[n2];
                        OP.copy(modim, new File(Start.sport, "Result"));
                        ++n2;
                    }
                }
                catch (Exception e) {
                    this.detBarInf.setText("Errorocde: S3x05: " + String.valueOf(e));
                    errors = String.valueOf(errors) + OP.getError(e) + " Errorcode: S3x05\n\n";
                }
            } else {
                try {
                    File[] fileArray = impf.listFiles();
                    int n = fileArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        modim = fileArray[n3];
                        OP.copy(modim, new File(Start.mineord, "mods/" + modim.getName()));
                        ++n3;
                    }
                }
                catch (Exception e) {
                    this.detBarInf.setText("Errorocde: S3x06: " + String.valueOf(e));
                    errors = String.valueOf(errors) + OP.getError(e) + " Errorcode: S3x06\n\n";
                }
            }
            File impo = new File(Start.sport, "Importo");
            OP.del(impo);
            try {
                OP.rename(impf, impo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setProfiles() {
        File profiles = new File(Start.mineord, "launcher_profiles.json");
        boolean emty = false;
        if (!profiles.exists()) {
            emty = true;
            try {
                profiles.createNewFile();
            }
            catch (IOException e) {
                this.detBarInf.setText("Errorocde: S3xPR: " + String.valueOf(e));
                errors = String.valueOf(errors) + OP.getError(e) + " Errorcode: S3xPR\n\n";
            }
        }
        Gson gson = new Gson();
        JsonObject jfile = null;
        JsonObject jprofiles = null;
        if (emty || profiles.length() < 10L) {
            jfile = new JsonObject();
            jprofiles = new JsonObject();
        } else {
            try {
                String jsontext = OP.Textreaders(profiles);
                jfile = gson.fromJson(jsontext, JsonObject.class);
                jprofiles = jfile.has("profiles") ? jfile.get("profiles").getAsJsonObject() : new JsonObject();
            }
            catch (Exception e) {
                jfile = new JsonObject();
                jprofiles = new JsonObject();
                this.detBarInf.setText("Errorocde: S3xPRO1: " + String.valueOf(e));
                errors = String.valueOf(errors) + OP.getError(e) + " Errorcode: S3xPR01\n\n";
            }
        }
        JsonObject sub = new JsonObject();
        sub.addProperty("name", "Modinstaller");
        sub.addProperty("lastVersionId", "Modinstaller");
        Date dt = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        df.setTimeZone(TimeZone.getDefault());
        String datex = String.valueOf(df.format(dt).replace(" ", "T")) + "Z";
        sub.addProperty("lastUsed", datex);
        sub.addProperty("created", datex);
        sub.addProperty("type", "custom");
        if (sub.has("javaDir")) {
            sub.remove("javaDir");
        }
        if (sub.has("javaArgs")) {
            sub.remove("javaArgs");
        }
        jprofiles.add("Modinstaller", sub);
        jfile.add("profiles", jprofiles);
        jfile.addProperty("selectedProfile", "Modinstaller");
        try {
            Gson gson2 = new GsonBuilder().setPrettyPrinting().create();
            OP.Textwriter(profiles, gson2.toJson(jfile), false);
        }
        catch (IOException e) {
            this.detBarInf.setText("Errorocde: S3xPRO2: " + String.valueOf(e));
            errors = String.valueOf(errors) + OP.getError(e) + " Errorcode: S3xPR02\n\n";
        }
    }

    private void modifyServerlist() {
        File jsonfile = new File(Start.sport, "serverlist.json");
        try {
            new Downloader("https://www.minecraft-installer.de/api/serverlist.json", jsonfile).run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (jsonfile.exists() && jsonfile.length() > 2L) {
            try {
                Object oldserverentries = new ArrayList();
                File sd = new File(Start.mineord, "servers.dat");
                if (sd.exists()) {
                    FileInputStream fis = null;
                    NBTInputStream nis = null;
                    try {
                        fis = new FileInputStream(sd);
                        nis = new NBTInputStream(fis, false);
                        CompoundTag master = (CompoundTag)nis.readTag();
                        CompoundMap map = master.getValue();
                        Set<Map.Entry<String, Tag>> s = map.entrySet();
                        Iterator<Map.Entry<String, Tag>> it = s.iterator();
                        Map.Entry<String, Tag> m = it.next();
                        ListTag value = (ListTag)m.getValue();
                        oldserverentries = value.getValue();
                    }
                    finally {
                        if (nis != null) {
                            nis.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                    }
                } else {
                    sd.createNewFile();
                }
                CompoundMap map3 = new CompoundMap();
                ArrayList<CompoundTag> serverentries = new ArrayList<CompoundTag>();
                Gson gson = new Gson();
                String jsontext = OP.Textreaders(jsonfile);
                JsonArray jsona1 = gson.fromJson(jsontext, JsonArray.class);
                int i = 0;
                while (i < jsona1.size()) {
                    block23: {
                        String Servername = "";
                        String Serverip = "";
                        String Servericon = "";
                        JsonObject jsono3 = jsona1.get(i).getAsJsonObject();
                        if (jsono3.has("name")) {
                            Servername = jsono3.get("name").getAsString();
                        }
                        if (jsono3.has("ip")) {
                            Serverip = jsono3.get("ip").getAsString();
                        }
                        if (jsono3.has("icon")) {
                            Servericon = jsono3.get("icon").getAsString();
                        }
                        CompoundMap serverentry = new CompoundMap();
                        serverentry.put(new StringTag("name", Servername));
                        serverentry.put(new StringTag("ip", Serverip));
                        serverentry.put(new StringTag("icon", Servericon));
                        int j = 0;
                        while (j < oldserverentries.size()) {
                            if (!((CompoundTag)oldserverentries.get(j)).getValue().get("ip").getValue().equals(Serverip)) {
                                ++j;
                                continue;
                            }
                            break block23;
                        }
                        serverentries.add(new CompoundTag("", serverentry));
                    }
                    ++i;
                }
                serverentries.addAll((Collection<CompoundTag>)oldserverentries);
                map3.put(new ListTag<CompoundTag>("servers", CompoundTag.class, serverentries));
                FileOutputStream fos = null;
                NBTOutputStream nos = null;
                try {
                    fos = new FileOutputStream(sd);
                    nos = new NBTOutputStream(fos, false);
                    CompoundTag exit = new CompoundTag("", map3);
                    nos.writeTag(exit);
                }
                finally {
                    if (nos != null) {
                        nos.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                OP.del(jsonfile);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void changeSymbols(boolean finished) {
        this.startMCButton.setEnabled(finished);
        detBar.setVisible(!finished);
        mainBar.setVisible(!finished);
        this.detBarInf.setVisible(!finished);
        this.mainBarInf.setVisible(!finished);
        this.stateIcon.setVisible(!finished);
        int i = 0;
        while (i < this.socialIcons.length) {
            this.socialIcons[i].setVisible(finished);
            ++i;
        }
        this.startinfo.setVisible(finished);
        if (finished) {
            this.info.setText(Read.getTextwith("Install", "head1"));
            this.stateIcon.setIcon(new ImageIcon(this.getClass().getResource("src/play.png")));
        }
    }

    private void mainState(double number) {
        mainBar.setValue((int)number);
    }

    public static void detState(double number) {
        detBar.setValue((int)number);
    }
}

