/*
 * Decompiled with CFR 0.152.
 */
package installer;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;

public class HintTextField
extends JTextField
implements FocusListener {
    private static final long serialVersionUID = 4677918701886147670L;
    private final String hint;
    private boolean showingHint;
    private Color stdc;

    public HintTextField(String hint) {
        super(hint);
        this.hint = hint;
        this.stdc = super.getForeground();
        super.setForeground(Color.GRAY);
        this.showingHint = true;
        super.addFocusListener(this);
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.getText().isEmpty()) {
            super.setText("");
            super.setForeground(this.stdc);
            this.showingHint = false;
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.getText().isEmpty()) {
            this.reset();
        }
    }

    public void reset() {
        super.setText(this.hint);
        super.setForeground(Color.GRAY);
        this.showingHint = true;
    }

    @Override
    public String getText() {
        return this.showingHint ? "" : super.getText();
    }
}

