/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.Read;
import installer.seite1;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.channels.ByteChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import javax.swing.JOptionPane;

public class OP {
    public boolean del(File dir) {
        if (dir.exists()) {
            File f = dir;
            if (f.isDirectory()) {
                File[] files;
                File[] fileArray = files = f.listFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File aktFile = fileArray[n2];
                    this.del(aktFile);
                    ++n2;
                }
            }
            return f.delete();
        }
        return false;
    }

    public void copy(File quelle, File ziel) throws FileNotFoundException, IOException {
        if (quelle.exists()) {
            if (quelle.isDirectory()) {
                this.makedirs(ziel);
                this.copyDir(quelle, ziel);
            } else {
                this.makedirs(ziel.getParentFile());
                OP.copyFile(quelle, ziel);
            }
        }
    }

    public static void copyFile(File source, File target) throws IOException {
        if (!target.exists()) {
            target.createNewFile();
        }
        FileChannel sourceChannel = null;
        AbstractInterruptibleChannel targetChannel = null;
        try {
            sourceChannel = new FileInputStream(source).getChannel();
            targetChannel = new FileOutputStream(target).getChannel();
            ((FileChannel)targetChannel).transferFrom(sourceChannel, 0L, sourceChannel.size());
        }
        finally {
            if (sourceChannel != null) {
                sourceChannel.close();
            }
            if (targetChannel != null) {
                targetChannel.close();
            }
        }
    }

    public static void transfer(FileChannel inputChannel, ByteChannel outputChannel, long lengthInBytes, long chunckSizeInBytes, boolean verbose) throws IOException {
        long overallBytesTransfered = 0L;
        long time = -System.currentTimeMillis();
        while (overallBytesTransfered < lengthInBytes) {
            long bytesToTransfer = Math.min(chunckSizeInBytes, lengthInBytes - overallBytesTransfered);
            long bytesTransfered = inputChannel.transferTo(overallBytesTransfered, bytesToTransfer, outputChannel);
            overallBytesTransfered += bytesTransfered;
            if (!verbose) continue;
            long percentageOfOverallBytesTransfered = Math.round((double)overallBytesTransfered / (double)lengthInBytes * 100.0);
            System.out.printf("overall bytes transfered: %s progress %s%%\n", overallBytesTransfered, percentageOfOverallBytesTransfered);
        }
        time += System.currentTimeMillis();
        if (verbose) {
            double kiloBytesPerSecond = (double)overallBytesTransfered / 1024.0 / ((double)time / 1000.0);
            System.out.printf("Transfered: %s bytes in: %s s -> %s kbytes/s", overallBytesTransfered, time / 1000L, kiloBytesPerSecond);
        }
    }

    public void copyDir(File quelle, File ziel) throws FileNotFoundException, IOException {
        File[] files = quelle.listFiles();
        ziel.mkdirs();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.copyDir(file, new File(String.valueOf(ziel.getAbsolutePath()) + System.getProperty("file.separator") + file.getName()));
            } else {
                OP.copyFile(file, new File(String.valueOf(ziel.getAbsolutePath()) + System.getProperty("file.separator") + file.getName()));
            }
            ++n2;
        }
    }

    public void rename(File alt, File neu) throws FileNotFoundException, IOException {
        alt.renameTo(neu);
    }

    public void makedirs(File f) {
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public void Textwriter(File datei, String[] lines, boolean weiterschreiben) throws IOException {
        boolean umbruch = false;
        if (datei.length() != 0L && weiterschreiben) {
            umbruch = true;
        }
        BufferedWriter f = new BufferedWriter(new FileWriter(datei.toString(), weiterschreiben));
        int i = 0;
        while (i < lines.length) {
            if (umbruch) {
                f.newLine();
            }
            f.write(lines[i]);
            if (i < lines.length - 1) {
                f.newLine();
            }
            ++i;
        }
        f.close();
    }

    public String[] Textreader(File datei) throws IOException {
        String line;
        String alles = "";
        BufferedReader f = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(datei), "ISO-8859-3"));
        while ((line = f.readLine()) != null) {
            alles = String.valueOf(alles) + line + ";;;;";
        }
        f.close();
        if (alles.endsWith(";;;;")) {
            alles.substring(0, alles.length() - 4);
        }
        return alles.split(";;;;");
    }

    public int version(String[] options) {
        return JOptionPane.showOptionDialog(null, Read.getTextwith("OP", "modver"), Read.getTextwith("OP", "modverh"), -1, 3, null, options, options[0]);
    }

    public String optionReader(String attrib) throws IOException {
        File configf = new File(String.valueOf(seite1.stamm) + "/Modinstaller/config.txt");
        String[] inhalt = this.Textreader(configf);
        String rueck = null;
        boolean exist = false;
        int i = 0;
        while (i < inhalt.length) {
            if (inhalt[i].split(":")[0].equals(attrib)) {
                rueck = inhalt[i].split(":")[1];
                exist = true;
            }
            ++i;
        }
        if (!exist) {
            rueck = "n/a";
        }
        return rueck;
    }

    public void optionWriter(String attrib, String content) throws IOException {
        File configf = new File(String.valueOf(seite1.stamm) + "/Modinstaller/config.txt");
        String[] inhalt = this.Textreader(configf);
        boolean inside = false;
        int i = 0;
        while (i < inhalt.length) {
            if (inhalt[i].split(":")[0].equals(attrib)) {
                inhalt[i] = String.valueOf(inhalt[i].split(":")[0]) + ":" + content;
                inside = true;
            }
            ++i;
        }
        if (inside) {
            this.Textwriter(configf, inhalt, false);
        } else {
            String[] neu = new String[]{String.valueOf(attrib) + ":" + content};
            this.Textwriter(configf, neu, true);
        }
    }

    public String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }
}

