/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.ImageScaler;
import installer.Read;
import installer.Start;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;

public class Fullscreen
extends JFrame
implements ActionListener,
KeyListener,
MouseWheelListener {
    private static final long serialVersionUID = 1L;
    private JLabel headl = new JLabel();
    private JLabel headl2 = new JLabel();
    private JLabel bild = new JLabel();
    private JButton vor = new JButton();
    private JButton zurueck = new JButton();
    private JButton exit = new JButton();
    private Cursor curs1 = new Cursor(12);
    private String url;
    private int x = 0;
    private int y = 0;
    private int i = 0;
    private String modname;
    private DefaultListModel<String> model;
    private boolean geladen = false;
    private boolean neu = true;

    public Fullscreen(JList<String> list, DefaultListModel<String> model) {
        super(Read.getTextwith("installer", "name"));
        this.model = model;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                Fullscreen.this.dispose();
            }
        });
        this.modname = model.getElementAt(list.getSelectedIndex());
        this.i = list.getSelectedIndex();
        this.setUndecorated(true);
        this.setResizable(false);
        this.setBackground(Color.BLACK);
        this.setIconImage(new ImageIcon(this.getClass().getResource("src/icon.png")).getImage());
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        gd.setFullScreenWindow(this);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.x = d.width;
        this.y = d.height;
        Container cp = this.getContentPane();
        cp.setLayout(null);
        cp.setBackground(Color.BLACK);
        cp.addKeyListener(this);
        this.headl.setBounds(0, 25, this.x, 50);
        this.headl.setBackground(Color.decode("#FFF9E9"));
        this.headl.setHorizontalAlignment(0);
        this.headl.setFont(Start.lcd.deriveFont(1, 40.0f));
        cp.add(this.headl);
        this.headl2.setBounds(3, 27, this.x - 3, 50);
        this.headl2.setBackground(null);
        this.headl2.setForeground(Color.WHITE);
        this.headl2.setHorizontalAlignment(0);
        this.headl2.setFont(Start.lcd.deriveFont(1, 40.0f));
        cp.add(this.headl2);
        int khoehe = 100;
        int kbreite = 60;
        this.vor.setBounds(-5, this.y / 2 - khoehe / 2, kbreite, khoehe);
        this.vor.setText("<<");
        this.vor.setCursor(this.curs1);
        this.vor.addMouseWheelListener(this);
        this.vor.addKeyListener(this);
        this.vor.setFont(new Font("Arial", 1, 25));
        this.vor.addActionListener(this);
        cp.add(this.vor);
        this.zurueck.setBounds(this.x - kbreite + 5, this.y / 2 - khoehe / 2, kbreite, khoehe);
        this.zurueck.setText(">>");
        this.zurueck.addMouseWheelListener(this);
        this.zurueck.setCursor(this.curs1);
        this.zurueck.addKeyListener(this);
        this.zurueck.setFont(new Font("Arial", 1, 25));
        this.zurueck.addActionListener(this);
        cp.add(this.zurueck);
        this.exit.setBounds(this.x - 40, -5, 45, 45);
        this.exit.setText("X");
        this.exit.addMouseWheelListener(this);
        this.exit.setCursor(this.curs1);
        this.exit.addKeyListener(this);
        this.exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fullscreen.this.dispose();
            }
        });
        this.exit.setFont(new Font("Arial", 1, 18));
        this.exit.addActionListener(this);
        cp.add(this.exit);
        int hoehe = this.y;
        int breite = this.x;
        int abstandoben = 0;
        int abstandlinks = 0;
        this.bild.addKeyListener(this);
        this.bild.addMouseWheelListener(this);
        this.bild.setHorizontalAlignment(0);
        this.bild.setVerticalAlignment(0);
        this.bild.setBounds(abstandlinks, abstandoben, breite, hoehe);
        this.laden();
        cp.add(this.bild);
        this.setVisible(true);
    }

    public void laden() {
        this.bild.setText("");
        this.geladen = false;
        this.neu = true;
        this.headl.setText(this.modname);
        this.headl2.setText(this.modname);
        this.url = "http://www.minecraft-installer.de/Dateien/BilderHQ/" + this.modname + ".jpg";
        this.url = this.url.replace(" ", "%20");
        try {
            this.bild.setIcon(new ImageIcon(this.getClass().getResource("src/warten.gif")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Thread t1 = new Thread(){

            @Override
            public void run() {
                try {
                    BufferedImage img = ImageIO.read(new URL(Fullscreen.this.url));
                    int dx = img.getWidth();
                    int dy = img.getHeight();
                    double verh = (double)dy / (double)dx;
                    if (dx > Fullscreen.this.x) {
                        dx = Fullscreen.this.x;
                        dy = (int)((double)Fullscreen.this.x * verh);
                    }
                    if (dy > Fullscreen.this.y) {
                        dx = (int)((double)Fullscreen.this.y / verh);
                        dy = Fullscreen.this.y;
                    }
                    img = new ImageScaler().scaleImage(img, new Dimension(dx, dy));
                    Fullscreen.this.bild.setIcon(new ImageIcon(img));
                    img.flush();
                }
                catch (Exception e) {
                    Fullscreen.this.bild.setText("Kein Bild verf\u00fcgbar...");
                    Fullscreen.this.bild.setIcon(null);
                }
                Fullscreen.this.geladen = true;
                if (!Fullscreen.this.neu) {
                    Fullscreen.this.laden();
                }
            }
        };
        t1.start();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.vor) {
            this.vor();
        }
        if (ae.getSource() == this.zurueck) {
            this.zurueck();
        }
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
        int keyCode = arg0.getKeyCode();
        switch (keyCode) {
            case 27: {
                this.dispose();
                break;
            }
            case 38: {
                this.vor();
                break;
            }
            case 40: {
                this.zurueck();
                break;
            }
            case 37: {
                this.vor();
                break;
            }
            case 39: {
                this.zurueck();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    public void vor() {
        --this.i;
        if (this.i < 0) {
            this.i = this.model.getSize() - 1;
        }
        this.modname = this.model.getElementAt(this.i);
        this.headl.setText(this.modname);
        this.headl2.setText(this.modname);
        if (this.geladen) {
            this.laden();
        } else {
            this.neu = false;
        }
    }

    public void zurueck() {
        ++this.i;
        if (this.i > this.model.getSize() - 1) {
            this.i = 0;
        }
        this.modname = this.model.getElementAt(this.i);
        this.headl.setText(this.modname);
        this.headl2.setText(this.modname);
        if (this.geladen) {
            this.laden();
        } else {
            this.neu = false;
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent arg0) {
        int notches = arg0.getWheelRotation();
        if (notches < 0) {
            this.vor();
        } else {
            this.zurueck();
        }
    }
}

