/*
 * Decompiled with CFR 0.152.
 */
package installer;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import installer.Compress;
import installer.Download;
import installer.Extract;
import installer.FileFinder;
import installer.ImageScaler;
import installer.Menu;
import installer.MenuGUI;
import installer.OP;
import installer.Read;
import installer.Start;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class Import {
    private String stamm = Start.stamm;
    private boolean Modloader = Menu.isModloader;
    private File sport = new File(String.valueOf(this.stamm) + "Modinstaller/Import/");
    private File sportn = new File(String.valueOf(this.stamm) + "Modinstaller/Importn/");
    private File extr = new File(String.valueOf(this.stamm) + "Modinstaller/Importc/");
    private File extr2 = new File(String.valueOf(this.stamm) + "Modinstaller/Importc2/");
    private String modName = "";
    private String modVersion = "";
    private String mcVersion = "";
    private String description = "";
    private String authors = "";
    private String website = "";
    private String credits = "";
    private String requiredMods = "";
    private String modLogo = "";
    private MenuGUI men;

    public Import(File datei, MenuGUI men) {
        this.men = men;
        this.setImport();
        OP.del(this.extr);
        OP.del(this.extr2);
        OP.makedirs(this.sportn);
        OP.makedirs(this.extr);
        if (!this.Modloader) {
            try {
                this.sucher(datei);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.modName.equals("")) {
                this.description = Read.getTextwith("modimport", "nomodinfo");
                this.website = String.valueOf(Read.getTextwith("installer", "website")) + "faq.php?id=nomodinfo";
                this.modName = datei.isFile() ? datei.getName().substring(0, datei.getName().lastIndexOf(".")) : datei.getName();
                File importf = new File(this.sport + "/" + this.modName + ".jar");
                try {
                    OP.copy(datei, importf);
                }
                catch (Exception exception) {}
            } else {
                try {
                    if (!Start.sent.contains(this.modName)) {
                        String body = "Name=" + this.modName.replace("'", "`") + "&" + "MCVersion=" + this.mcVersion.replace("'", "`") + "&" + "ModVersion=" + URLEncoder.encode(this.modVersion.replace("'", "`"), "UTF-8") + "&" + "Requires=" + URLEncoder.encode(this.requiredMods.replace("'", "`"), "UTF-8") + "&" + "Description=" + this.description.replace("'", "`") + "&" + "Web=" + URLEncoder.encode(this.website.replace("'", "`"), "UTF-8");
                        Start.sent.add(this.modName);
                        new Download().post("http://www.minecraft-installer.de/api/imports.php", body);
                    }
                }
                catch (Exception body) {}
            }
        } else {
            String name = datei.getName();
            File modspo = new File(String.valueOf(this.sport.getAbsolutePath()) + "/" + name);
            modspo.mkdirs();
            if (datei.isFile()) {
                String Dateiendung = datei.getName().substring(datei.getName().lastIndexOf("."));
                if (Dateiendung.equals(".jar") || Dateiendung.equals(".zip")) {
                    try {
                        new Extract(datei, modspo);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        OP.copy(datei, new File(String.valueOf(modspo.getAbsolutePath()) + "/" + name));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                try {
                    OP.copy(datei, modspo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.setListEntry(name);
            this.modName = name;
            this.description = Read.getTextwith("seite2", "importm");
            this.website = String.valueOf(Read.getTextwith("installer", "website")) + "faq.php?id=importm";
        }
        if (this.sport.exists()) {
            File[] imports;
            File[] fileArray = imports = this.sport.listFiles();
            int n = imports.length;
            int n2 = 0;
            while (n2 < n) {
                File modi = fileArray[n2];
                this.setListEntry(modi.getName().substring(0, modi.getName().lastIndexOf(".")));
                ++n2;
            }
        }
        this.make(new File(this.sport + "/" + this.modName + ".jar"));
    }

    private void setImport() {
        this.men.modinstWebLnk.setVisible(false);
        this.men.modVersionL.setVisible(true);
        this.men.topIcon.setVisible(false);
        JLabel[] jLabelArray = this.men.ratIcons;
        int n = this.men.ratIcons.length;
        int n2 = 0;
        while (n2 < n) {
            JLabel ic = jLabelArray[n2];
            ic.setVisible(false);
            ++n2;
        }
    }

    public void sucher(File datei) {
        OP.del(this.extr);
        if (datei.isFile()) {
            String Dateiendung = datei.getName().substring(datei.getName().lastIndexOf("."));
            if (Dateiendung.equals(".jar") || Dateiendung.equals(".zip")) {
                if (Dateiendung.equals(".jar")) {
                    String info = this.getModinfoStringFromJAR(datei);
                    if (!info.equals("")) {
                        this.modName = this.updateCat(info);
                        File importf = new File(this.sport + "/" + this.modName + ".jar");
                        try {
                            OP.copy(datei, importf);
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    try {
                        this.extr.mkdirs();
                        new Extract(datei, this.extr);
                        this.searchInfo(this.extr);
                        try {
                            File[] jars = this.searchFile(this.extr, ".jar");
                            int j = 0;
                            while (j < jars.length) {
                                OP.del(this.extr2);
                                new Extract(jars[j], this.extr2);
                                this.searchInfo(this.extr2);
                                ++j;
                            }
                        }
                        catch (Exception jars) {
                            // empty catch block
                        }
                        try {
                            File[] zips = this.searchFile(this.extr, ".zip");
                            int z = 0;
                            while (z < zips.length) {
                                OP.del(this.extr2);
                                new Extract(zips[z], this.extr2);
                                this.searchInfo(this.extr2);
                                ++z;
                            }
                        }
                        catch (Exception zips) {
                        }
                    }
                    catch (Exception zips) {}
                }
            }
        } else {
            File[] jars = this.searchFile(datei, ".jar");
            int j = 0;
            while (j < jars.length) {
                this.sucher(jars[j]);
                ++j;
            }
            File[] zips = this.searchFile(datei, ".zip");
            int z = 0;
            while (z < zips.length) {
                this.sucher(zips[z]);
                ++z;
            }
            this.searchInfo(datei);
        }
    }

    private void searchInfo(File datei) {
        File[] fileArray = datei.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                if (file.getName().equals("mcmod.info")) {
                    String modname = this.updateCat(this.getModinfoStringFromFile(file));
                    File path = new File(String.valueOf(this.sportn.getAbsolutePath()) + "/" + modname);
                    path.mkdirs();
                    try {
                        OP.copy(datei, path);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    new Compress(path, new File(String.valueOf(this.sport.getAbsolutePath()) + "/" + modname + ".jar"));
                }
            } else {
                this.searchInfo(file);
            }
            ++n2;
        }
    }

    public String getModinfoStringFromFile(File modinfo) {
        new OP();
        try {
            return OP.Textreaders(modinfo);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public String getModinfoStringFromJAR(File jarfile) {
        StringBuilder builder = new StringBuilder();
        InputStream in = null;
        String inputFile = "jar:file:/" + jarfile.getAbsolutePath() + "!/mcmod.info";
        if (inputFile.startsWith("jar:")) {
            try {
                int ch;
                URL inputURL = new URL(inputFile);
                JarURLConnection conn = (JarURLConnection)inputURL.openConnection();
                in = conn.getInputStream();
                while ((ch = in.read()) != -1) {
                    builder.append((char)ch);
                }
                in.close();
                return builder.toString();
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    public String updateCat(String jsontext) {
        Gson gson = new Gson();
        try {
            String neu;
            JsonArray jsona1 = null;
            JsonObject jsono1 = null;
            try {
                jsona1 = gson.fromJson(jsontext, JsonArray.class);
                jsono1 = gson.fromJson(jsona1.get(0), JsonObject.class);
            }
            catch (Exception e) {
                JsonObject jsonoa = gson.fromJson(jsontext, JsonObject.class);
                jsono1 = jsonoa.get("modList").getAsJsonArray().get(0).getAsJsonObject();
            }
            try {
                this.modName = jsono1.get("name").getAsString();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.modVersion = jsono1.get("version").getAsString();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.modLogo = jsono1.get("logoFile").getAsString().replace("\\", "/");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.mcVersion = jsono1.get("mcversion").getAsString();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.description = jsono1.get("description").getAsString();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                neu = "";
                JsonArray Autorena = jsono1.get("authorList").getAsJsonArray();
                int i = 0;
                while (i < Autorena.size()) {
                    neu = String.valueOf(neu) + Autorena.get(i).getAsString() + ", ";
                    ++i;
                }
                if (neu.length() > 0) {
                    this.authors = neu.substring(0, neu.length() - 2);
                }
            }
            catch (Exception e) {
                try {
                    String neu2 = "";
                    JsonArray Autorena = jsono1.get("authors").getAsJsonArray();
                    int i = 0;
                    while (i < Autorena.size()) {
                        neu2 = String.valueOf(neu2) + Autorena.get(i).getAsString() + ", ";
                        ++i;
                    }
                    if (neu2.length() > 0) {
                        this.authors = neu2.substring(0, neu2.length() - 2);
                    }
                }
                catch (Exception neu2) {
                    // empty catch block
                }
            }
            try {
                this.website = jsono1.get("url").getAsString();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.credits = jsono1.get("credits").getAsString();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                neu = "";
                JsonArray Benoetigta = jsono1.get("dependencies").getAsJsonArray();
                int i = 0;
                while (i < Benoetigta.size()) {
                    neu = String.valueOf(neu) + Benoetigta.get(i).getAsString() + ", ";
                    ++i;
                }
                if (neu.length() > 0) {
                    this.requiredMods = neu.substring(0, neu.length() - 2);
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.modName;
    }

    private void setListEntry(String name) {
        if (!this.men.rightListModel.contains("+ " + name)) {
            this.men.nextButton.setEnabled(true);
            this.men.rightListModel.addElement("+ " + name);
            this.men.rightList.setSelectedIndex(this.men.rightListModel.size() - 1);
        }
    }

    public File[] searchFile(File ordner, String suche) {
        FileFinder ff = new FileFinder();
        ff.sucheDatei(suche, ordner, null);
        File[] fs = new File[ff.findings.size()];
        int i = 0;
        while (i < ff.findings.size()) {
            fs[i] = ff.findings.get(i);
            ++i;
        }
        return fs;
    }

    public Import(String modName, MenuGUI men) {
        this.modName = modName;
        this.men = men;
        this.setImport();
        File jarfile = new File(String.valueOf(this.sport.getAbsolutePath()) + "/" + modName + ".jar");
        if (jarfile.exists()) {
            String cont = this.getModinfoStringFromJAR(jarfile);
            if (!cont.equals("")) {
                this.updateCat(cont);
            }
            this.make(jarfile);
        }
    }

    public void make(File jarfile) {
        boolean picfound = false;
        if (!this.modLogo.equals("")) {
            JLabel bild = new JLabel();
            bild.setHorizontalAlignment(0);
            InputStream in = null;
            try {
                String inputFile = "jar:file:/" + jarfile.getAbsolutePath().replace("\\", "/") + "!/" + this.modLogo;
                URL inputURL = new URL(inputFile);
                JarURLConnection conn = (JarURLConnection)inputURL.openConnection();
                in = conn.getInputStream();
                BufferedImage bi = ImageIO.read(in);
                this.men.picture.setIcon(new ImageIcon(new ImageScaler().scaleImage(bi, new Dimension(390, 215))));
                in.close();
                picfound = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!picfound) {
            this.men.picture.setIcon(new ImageIcon(this.getClass().getResource("src/mods.png")));
        }
        this.men.sizeLabel.setText(new OP().getSizeAsString(jarfile.length()));
        this.men.website = this.website;
        this.men.modNameLabel.setText(this.modName);
        this.men.modVersionL.setText("Mod v. " + this.modVersion);
        String text = "<html><body>";
        if (!this.mcVersion.equals("") && !this.mcVersion.contains(Start.mcVersion)) {
            text = String.valueOf(text) + Read.getTextwith("modimport", "warning1") + this.mcVersion + "!</b><br><br>";
        }
        text = String.valueOf(text) + this.description + "<br><br>";
        if (!this.requiredMods.equals("")) {
            text = String.valueOf(text) + "<b>" + Read.getTextwith("modimport", "requiredMods") + "</b>: " + this.requiredMods + "<br><br>";
        }
        if (!this.authors.equals("")) {
            text = String.valueOf(text) + "<b>" + Read.getTextwith("modimport", "authors") + "</b>: " + this.authors + "<br><br>";
        }
        if (!this.credits.equals("")) {
            text = String.valueOf(text) + "<b>" + Read.getTextwith("modimport", "credits") + "</b>: " + this.credits + "<br><br>";
        }
        text = text.substring(0, text.length() - 8);
        this.men.modDescPane.setText(text);
    }
}

