/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.ImageScaler;
import installer.Modinfo;
import installer.Read;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class Fullscreen
extends JFrame
implements ActionListener,
KeyListener,
MouseWheelListener {
    private static final long serialVersionUID = 1L;
    private JLabel headl = new JLabel();
    private JLabel headl2 = new JLabel();
    private JLabel hdPicture = new JLabel();
    private JButton nextButton = new JButton();
    private JButton backButton = new JButton();
    private JButton exitButton = new JButton();
    private Cursor curs1 = new Cursor(12);
    private String url;
    private int x = 0;
    private int y = 0;
    private int i = 0;
    private Modinfo[] modtexts;
    private String modname;
    private ArrayList<Modinfo> proposals;
    private boolean geladen = false;
    private boolean neu = true;

    public Fullscreen(Modinfo[] modtexts, String modname, ArrayList<Modinfo> proposals) {
        super(Read.getTextwith("installer", "name"));
        this.modtexts = modtexts;
        this.modname = modname;
        this.proposals = proposals;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                Fullscreen.this.dispose();
            }
        });
        int j = 0;
        while (j < modtexts.length) {
            if (modtexts[j].getName().equals(modname)) {
                this.i = j;
            }
            ++j;
        }
        this.setUndecorated(true);
        this.setResizable(false);
        this.setBackground(Color.BLACK);
        this.setIconImage(new ImageIcon(this.getClass().getResource("src/icon.png")).getImage());
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        gd.setFullScreenWindow(this);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.x = d.width;
        this.y = d.height;
        Container cp = this.getContentPane();
        cp.setLayout(null);
        cp.setBackground(Color.BLACK);
        cp.addKeyListener(this);
        this.headl.setBounds(0, 25, this.x, 60);
        this.headl.setBackground(Color.decode("#FFF9E9"));
        this.headl.setHorizontalAlignment(0);
        this.headl.setFont(this.getFont().deriveFont(1, 45.0f));
        cp.add(this.headl);
        this.headl2.setBounds(3, 24, this.x, 60);
        this.headl2.setBackground(null);
        this.headl2.setForeground(Color.WHITE);
        this.headl2.setHorizontalAlignment(0);
        this.headl2.setFont(this.getFont().deriveFont(1, 45.0f));
        this.headl2.setVisible(false);
        cp.add(this.headl2);
        int khoehe = (int)((double)this.y * 0.9);
        int kbreite = (int)((double)this.x * 0.4);
        this.nextButton.setBounds(-5, this.y / 2 - khoehe / 2, kbreite, khoehe);
        this.nextButton.setText("<<");
        this.nextButton.setCursor(this.curs1);
        this.nextButton.addMouseWheelListener(this);
        this.nextButton.addKeyListener(this);
        this.nextButton.setHorizontalAlignment(2);
        this.nextButton.setContentAreaFilled(false);
        this.nextButton.setFont(this.getFont().deriveFont(1, 40.0f));
        this.nextButton.addActionListener(this);
        cp.add(this.nextButton);
        this.backButton.setBounds(this.x - kbreite + 5, this.y / 2 - khoehe / 2, kbreite, khoehe);
        this.backButton.setText(">>");
        this.backButton.addMouseWheelListener(this);
        this.backButton.setCursor(this.curs1);
        this.backButton.setContentAreaFilled(false);
        this.backButton.addKeyListener(this);
        this.backButton.setHorizontalAlignment(4);
        this.backButton.setFont(this.getFont().deriveFont(1, 40.0f));
        this.backButton.addActionListener(this);
        cp.add(this.backButton);
        this.exitButton.setBounds(this.x - 35, 0, 35, 27);
        this.exitButton.setIcon(new ImageIcon(this.getClass().getResource("src/closeme.png")));
        this.exitButton.addMouseWheelListener(this);
        this.exitButton.setContentAreaFilled(false);
        this.exitButton.setCursor(this.curs1);
        this.exitButton.addKeyListener(this);
        this.exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Fullscreen.this.dispose();
            }
        });
        cp.add(this.exitButton);
        int hoehe = this.y;
        int breite = this.x;
        int abstandoben = 0;
        int abstandlinks = 0;
        this.hdPicture.addKeyListener(this);
        this.hdPicture.addMouseWheelListener(this);
        this.hdPicture.setHorizontalAlignment(0);
        this.hdPicture.setVerticalAlignment(0);
        this.hdPicture.setBounds(abstandlinks, abstandoben, breite, hoehe);
        this.laden();
        cp.add(this.hdPicture);
        this.setVisible(true);
    }

    public void laden() {
        this.hdPicture.setText("");
        this.headl2.setVisible(false);
        this.geladen = false;
        this.neu = true;
        this.headl.setText(this.modname);
        this.headl2.setText(this.modname);
        this.url = "http://www.minecraft-installer.de/Dateien/BilderHQ/" + this.modname + ".jpg";
        this.url = this.url.replace(" ", "%20");
        try {
            this.hdPicture.setIcon(new ImageIcon(this.getClass().getResource("src/wait3.gif")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    BufferedImage img = ImageIO.read(new URL(Fullscreen.this.url));
                    int dx = img.getWidth();
                    int dy = img.getHeight();
                    double verh = (double)dy / (double)dx;
                    if (dx > Fullscreen.this.x) {
                        dx = Fullscreen.this.x;
                        dy = (int)((double)Fullscreen.this.x * verh);
                    }
                    if (dy > Fullscreen.this.y) {
                        Fullscreen.this.x = (int)((double)Fullscreen.this.y / verh);
                        dy = Fullscreen.this.y;
                    }
                    img = new ImageScaler().scaleImage(img, new Dimension(dx, dy));
                    Fullscreen.this.hdPicture.setIcon(new ImageIcon(img));
                    Fullscreen.this.headl2.setVisible(true);
                    img.flush();
                }
                catch (Exception e) {
                    Fullscreen.this.hdPicture.setText(Read.getTextwith("seite2", "nopic"));
                    Fullscreen.this.hdPicture.setIcon(null);
                }
                Fullscreen.this.geladen = true;
                if (!Fullscreen.this.neu) {
                    Fullscreen.this.laden();
                }
            }
        }.start();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.nextButton) {
            this.next();
        }
        if (ae.getSource() == this.backButton) {
            this.back();
        }
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
        int keyCode = arg0.getKeyCode();
        switch (keyCode) {
            case 27: {
                this.dispose();
                break;
            }
            case 38: {
                this.next();
                break;
            }
            case 40: {
                this.back();
                break;
            }
            case 37: {
                this.next();
                break;
            }
            case 39: {
                this.back();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    public void next() {
        --this.i;
        if (this.i < 0) {
            this.i = this.modtexts.length - 1;
        }
        this.modname = this.modtexts[this.i].getName();
        boolean gef = false;
        for (Modinfo prop : this.proposals) {
            if (!prop.getName().equals(this.modname)) continue;
            gef = true;
        }
        if (!gef) {
            this.next();
        }
        this.headl.setText(this.modname);
        this.headl2.setText(this.modname);
        if (this.geladen) {
            this.laden();
        } else {
            this.neu = false;
        }
    }

    public void back() {
        ++this.i;
        if (this.i > this.modtexts.length - 1) {
            this.i = 0;
        }
        this.modname = this.modtexts[this.i].getName();
        boolean gef = false;
        for (Modinfo prop : this.proposals) {
            if (!prop.getName().equals(this.modname)) continue;
            gef = true;
        }
        if (!gef) {
            this.back();
        }
        this.headl.setText(this.modname);
        this.headl2.setText(this.modname);
        if (this.geladen) {
            this.laden();
        } else {
            this.neu = false;
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent arg0) {
        int notches = arg0.getWheelRotation();
        if (notches < 0) {
            this.next();
        } else {
            this.back();
        }
    }
}

