/*
 * Decompiled with CFR 0.152.
 */
package installer;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import installer.Compress;
import installer.Download;
import installer.Extract;
import installer.FileFinder;
import installer.ImageScaler;
import installer.Menu;
import installer.MenuGUI;
import installer.OP;
import installer.Read;
import installer.Start;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class Import {
    private String stamm = Start.stamm;
    private boolean Modloader = Menu.isModloader;
    private File sport = new File(String.valueOf(this.stamm) + "Modinstaller/Import/");
    private File sportn = new File(String.valueOf(this.stamm) + "Modinstaller/Importn/");
    private File extr = new File(String.valueOf(this.stamm) + "Modinstaller/Importc/");
    private File extr2 = new File(String.valueOf(this.stamm) + "Modinstaller/Importc2/");
    File nameu = null;
    private String modName = "";
    private String modVersion = "undefined";
    private String mcVersion = "undefined";
    private String description = "";
    private String authors = "";
    private String website = "";
    private String credits = "";
    private String requiredMods = "none";
    private String modLogo = "";
    private JTable table;
    private MenuGUI men;

    public Import(File datei, MenuGUI men) {
        this.men = men;
        OP.del(this.extr);
        OP.del(this.extr2);
        OP.makedirs(this.sportn);
        OP.makedirs(this.extr);
        if (!this.Modloader) {
            try {
                this.sucher(datei);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.modName.equals("")) {
                this.modName = datei.isFile() ? datei.getName().substring(0, datei.getName().lastIndexOf(".")) : datei.getName();
                JOptionPane.showMessageDialog(null, Read.getTextwith("modimport", "nomodinfo"));
                File importf = new File(this.sport + "/" + this.modName + ".jar");
                try {
                    OP.copy(datei, importf);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.updateList();
            }
        } else {
            String name = datei.getName();
            File modspo = new File(String.valueOf(this.sport.getAbsolutePath()) + "/" + name);
            modspo.mkdirs();
            if (datei.isFile()) {
                String Dateiendung = datei.getName().substring(datei.getName().lastIndexOf("."));
                if (Dateiendung.equals(".jar") || Dateiendung.equals(".zip")) {
                    try {
                        new Extract(datei, modspo);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        OP.copy(datei, new File(String.valueOf(modspo.getAbsolutePath()) + "/" + name));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                try {
                    OP.copy(datei, modspo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.setListEntry(name);
        }
    }

    public void sucher(File datei) {
        OP.del(this.extr);
        if (datei.isFile()) {
            String Dateiendung = datei.getName().substring(datei.getName().lastIndexOf("."));
            if (Dateiendung.equals(".jar") || Dateiendung.equals(".zip")) {
                if (Dateiendung.equals(".jar")) {
                    String info = this.getModinfoStringFromJAR(datei);
                    if (!info.equals("")) {
                        this.modName = this.updateCat(info);
                        this.make(datei);
                        File importf = new File(this.sport + "/" + this.modName + ".jar");
                        try {
                            OP.copy(datei, importf);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.updateList();
                    }
                } else {
                    try {
                        this.extr.mkdirs();
                        new Extract(datei, this.extr);
                        this.searchInfo(this.extr);
                        try {
                            File[] jars = this.searchFile(this.extr, ".jar");
                            int j = 0;
                            while (j < jars.length) {
                                OP.del(this.extr2);
                                new Extract(jars[j], this.extr2);
                                this.searchInfo(this.extr2);
                                ++j;
                            }
                        }
                        catch (Exception jars) {
                            // empty catch block
                        }
                        try {
                            File[] zips = this.searchFile(this.extr, ".zip");
                            int z = 0;
                            while (z < zips.length) {
                                OP.del(this.extr2);
                                new Extract(zips[z], this.extr2);
                                this.searchInfo(this.extr2);
                                ++z;
                            }
                        }
                        catch (Exception zips) {
                        }
                    }
                    catch (Exception zips) {}
                }
            }
        } else {
            File[] jars = this.searchFile(datei, ".jar");
            int j = 0;
            while (j < jars.length) {
                this.sucher(jars[j]);
                ++j;
            }
            File[] zips = this.searchFile(datei, ".zip");
            int z = 0;
            while (z < zips.length) {
                this.sucher(zips[z]);
                ++z;
            }
            this.searchInfo(datei);
        }
    }

    private void searchInfo(File datei) {
        File[] fileArray = datei.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                if (file.getName().equals("mcmod.info")) {
                    String modname = this.updateCat(this.getModinfoStringFromFile(file));
                    File path = new File(String.valueOf(this.sportn.getAbsolutePath()) + "/" + modname);
                    path.mkdirs();
                    try {
                        OP.copy(datei, path);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    new Compress(path, new File(String.valueOf(this.sport.getAbsolutePath()) + "/" + modname + ".jar"));
                    this.make(null);
                    this.updateList();
                }
            } else {
                this.searchInfo(file);
            }
            ++n2;
        }
    }

    public String getModinfoStringFromFile(File modinfo) {
        new OP();
        try {
            return OP.Textreaders(modinfo);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public String getModinfoStringFromJAR(File jarfile) {
        StringBuilder builder = new StringBuilder();
        InputStream in = null;
        String inputFile = "jar:file:/" + jarfile.getAbsolutePath() + "!/mcmod.info";
        if (inputFile.startsWith("jar:")) {
            try {
                int ch;
                URL inputURL = new URL(inputFile);
                JarURLConnection conn = (JarURLConnection)inputURL.openConnection();
                in = conn.getInputStream();
                while ((ch = in.read()) != -1) {
                    builder.append((char)ch);
                }
                in.close();
                return builder.toString();
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    public String updateCat(String jsontext) {
        Gson gson = new Gson();
        try {
            String neu;
            JsonArray jsona1 = null;
            JsonObject jsono1 = null;
            try {
                jsona1 = gson.fromJson(jsontext, JsonArray.class);
                jsono1 = gson.fromJson(jsona1.get(0), JsonObject.class);
            }
            catch (Exception e) {
                JsonObject jsonoa = gson.fromJson(jsontext, JsonObject.class);
                jsono1 = jsonoa.get("modList").getAsJsonArray().get(0).getAsJsonObject();
            }
            try {
                this.modName = jsono1.get("name").getAsString();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.modVersion = jsono1.get("version").getAsString();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.mcVersion = jsono1.get("mcversion").getAsString();
                if (!this.mcVersion.equals("") && !this.mcVersion.contains(Start.mcVersion)) {
                    JOptionPane.showMessageDialog(null, String.valueOf(Read.getTextwith("modimport", "mcVersionT1")) + this.mcVersion + Read.getTextwith("modimport", "mcVersionT2") + Start.mcVersion + Read.getTextwith("modimport", "mcVersionT3") + this.mcVersion + Read.getTextwith("modimport", "mcVersionT4"), Read.getTextwith("modimport", "mcVersionTh"), 2);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.description = this.stringBreak(jsono1.get("description").getAsString(), 58);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                neu = "";
                JsonArray Autorena = jsono1.get("authorList").getAsJsonArray();
                int i = 0;
                while (i < Autorena.size()) {
                    neu = String.valueOf(neu) + Autorena.get(i).getAsString() + ", ";
                    ++i;
                }
                if (neu.length() > 0) {
                    this.authors = neu.substring(0, neu.length() - 2);
                }
            }
            catch (Exception e) {
                try {
                    String neu2 = "";
                    JsonArray Autorena = jsono1.get("authors").getAsJsonArray();
                    int i = 0;
                    while (i < Autorena.size()) {
                        neu2 = String.valueOf(neu2) + Autorena.get(i).getAsString() + ", ";
                        ++i;
                    }
                    if (neu2.length() > 0) {
                        this.authors = neu2.substring(0, neu2.length() - 2);
                    }
                }
                catch (Exception neu2) {
                    // empty catch block
                }
            }
            try {
                this.website = jsono1.get("url").getAsString();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.credits = this.stringBreak(jsono1.get("credits").getAsString(), 58);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                neu = "";
                JsonArray Benoetigta = jsono1.get("dependencies").getAsJsonArray();
                int i = 0;
                while (i < Benoetigta.size()) {
                    neu = String.valueOf(neu) + Benoetigta.get(i).getAsString() + ", ";
                    ++i;
                }
                if (neu.length() > 0) {
                    this.requiredMods = neu.substring(0, neu.length() - 2);
                    if (!Start.sent.contains(this.modName) && !this.requiredMods.equals("mod_MinecraftForge")) {
                        JOptionPane.showMessageDialog(null, String.valueOf(Read.getTextwith("modimport", "requiredModsText")) + this.requiredMods, Read.getTextwith("modimport", "requiredModsTexth"), 1);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.modLogo = jsono1.get("logoFile").getAsString().replace("\\", "/");
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.modName;
    }

    private void updateList() {
        if (this.sport.exists()) {
            File[] imports;
            File[] fileArray = imports = this.sport.listFiles();
            int n = imports.length;
            int n2 = 0;
            while (n2 < n) {
                File modi = fileArray[n2];
                this.setListEntry(modi.getName().substring(0, modi.getName().lastIndexOf(".")));
                ++n2;
            }
        }
    }

    private void setListEntry(String name) {
        if (!this.men.rightListModel.contains("+ " + name)) {
            this.men.nextButton.setEnabled(true);
            this.men.rightListModel.addElement("+ " + name);
        }
    }

    private String stringBreak(String str, int maxLength) {
        ArrayList<String> strTmp = null;
        Pattern p = null;
        Matcher m = null;
        strTmp = new ArrayList<String>();
        p = Pattern.compile(".{1," + maxLength + "}$|.{1," + (maxLength - 1) + "}(\\.|,| )");
        m = p.matcher(str);
        while (m.find()) {
            strTmp.add(m.group());
        }
        String sn = "";
        int i = 0;
        while (i < strTmp.size()) {
            sn = String.valueOf(sn) + (String)strTmp.get(i) + "<br>";
            ++i;
        }
        return sn;
    }

    public File[] searchFile(File ordner, String suche) {
        FileFinder ff = new FileFinder();
        ff.sucheDatei(suche, ordner, null);
        File[] fs = new File[ff.findings.size()];
        int i = 0;
        while (i < ff.findings.size()) {
            fs[i] = ff.findings.get(i);
            ++i;
        }
        return fs;
    }

    public Import(String modName) {
        this.modName = modName;
        File jarfile = new File(String.valueOf(this.sport.getAbsolutePath()) + "/" + modName + ".jar");
        if (jarfile.exists()) {
            String cont = this.getModinfoStringFromJAR(jarfile);
            if (!cont.equals("")) {
                this.updateCat(cont);
            }
            this.make(jarfile);
        }
    }

    public void make(File jarfile) {
        JFrame wi = new JFrame();
        wi.setTitle(this.modName);
        wi.setResizable(true);
        wi.setIconImage(new ImageIcon(this.getClass().getResource("src/icon.png")).getImage());
        JPanel p1 = new JPanel();
        boolean text = true;
        boolean picfound = false;
        if (!this.modLogo.equals("")) {
            JLabel bild = new JLabel();
            bild.setHorizontalAlignment(0);
            String pfad = String.valueOf(this.extr.toString().replace("\\", "/")) + "/" + this.modLogo;
            File f = new File(pfad);
            if (!f.exists()) {
                if (this.modLogo.startsWith("mods")) {
                    this.modLogo = this.modLogo.substring(5);
                }
                pfad = String.valueOf(this.extr.toString().replace("\\", "/")) + "/assets/" + this.modLogo;
                f = new File(pfad);
            }
            if (f.exists()) {
                bild.setIcon(new ImageIcon(f.getAbsolutePath()));
                picfound = true;
            }
            if (!f.exists()) {
                InputStream in = null;
                try {
                    String inputFile = "jar:file:/" + jarfile.getAbsolutePath().replace("\\", "/") + "!/" + this.modLogo;
                    URL inputURL = new URL(inputFile);
                    JarURLConnection conn = (JarURLConnection)inputURL.openConnection();
                    in = conn.getInputStream();
                    BufferedImage bi = ImageIO.read(in);
                    bild.setIcon(new ImageIcon(new ImageScaler().scaleImage(bi, new Dimension(530, 150))));
                    in.close();
                    picfound = true;
                }
                catch (Exception e) {
                    try {
                        String inputFile = "jar:file:/" + jarfile.getAbsolutePath().replace("\\", "/") + "!" + this.modLogo;
                        URL inputURL = new URL(inputFile);
                        JarURLConnection conn = (JarURLConnection)inputURL.openConnection();
                        in = conn.getInputStream();
                        BufferedImage bi = ImageIO.read(in);
                        bild.setIcon(new ImageIcon(new ImageScaler().scaleImage(bi, new Dimension(530, 150))));
                        in.close();
                        picfound = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (picfound) {
                text = false;
                p1.add(bild);
            }
        }
        if (text) {
            JLabel head = new JLabel(this.modName);
            head.setFont(head.getFont().deriveFont(1, 35.0f));
            head.setHorizontalAlignment(0);
            p1.add(head);
        }
        DefaultTableModel model = new DefaultTableModel();
        model.setColumnIdentifiers(new Object[]{"", ""});
        model.insertRow(0, new Object[]{Read.getTextwith("modimport", "modVersion"), this.modVersion});
        model.insertRow(1, new Object[]{Read.getTextwith("modimport", "mcVersion"), this.mcVersion});
        model.insertRow(2, new Object[]{Read.getTextwith("modimport", "description"), "<html><body>" + this.description + "</body></html>"});
        model.insertRow(3, new Object[]{Read.getTextwith("modimport", "requiredMods"), this.requiredMods});
        model.insertRow(4, new Object[]{Read.getTextwith("modimport", "authors"), this.authors});
        model.insertRow(5, new Object[]{Read.getTextwith("modimport", "website"), this.website});
        model.insertRow(6, new Object[]{Read.getTextwith("modimport", "credits"), "<html><body>" + this.credits + "</body></html>"});
        this.table = new JTable(model){
            private static final long serialVersionUID = 1L;
            DefaultTableCellRenderer colortext;
            {
                this.colortext = new DefaultTableCellRenderer();
                this.colortext.setForeground(Color.decode("#9C2717"));
            }

            @Override
            public TableCellRenderer getCellRenderer(int arg0, int arg1) {
                return this.colortext;
            }
        };
        TableColumn col = this.table.getColumnModel().getColumn(0);
        col.setPreferredWidth(150);
        TableColumn col2 = this.table.getColumnModel().getColumn(1);
        col2.setPreferredWidth(400);
        this.updateRowHeights();
        JSplitPane pSplit = new JSplitPane(0);
        pSplit.add((Component)p1, "top");
        pSplit.add((Component)new JScrollPane(this.table), "bottom");
        wi.add(pSplit);
        wi.setSize(550, 435);
        wi.setLocationRelativeTo(null);
        wi.setVisible(true);
        try {
            if (!Start.sent.contains(this.modName)) {
                String body = "Name=" + this.modName.replace("'", "`") + "&" + "MCVersion=" + this.mcVersion.replace("'", "`") + "&" + "ModVersion=" + URLEncoder.encode(this.modVersion.replace("'", "`"), "UTF-8") + "&" + "Requires=" + URLEncoder.encode(this.requiredMods.replace("'", "`"), "UTF-8") + "&" + "Description=" + this.description.replace("'", "`") + "&" + "Web=" + URLEncoder.encode(this.website.replace("'", "`"), "UTF-8");
                Start.sent.add(this.modName);
                new Download().post("http://www.minecraft-installer.de/api/imports.php", body);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateRowHeights() {
        try {
            int row = 0;
            while (row < this.table.getRowCount()) {
                int rowHeight = this.table.getRowHeight();
                int column = 0;
                while (column < this.table.getColumnCount()) {
                    Component comp = this.table.prepareRenderer(this.table.getCellRenderer(row, column), row, column);
                    rowHeight = Math.max(rowHeight, comp.getPreferredSize().height) + 5;
                    ++column;
                }
                this.table.setRowHeight(row, rowHeight);
                ++row;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

