/*
 * Decompiled with CFR 0.152.
 */
package org.spout.nbt;

import org.spout.nbt.CompoundMap;
import org.spout.nbt.Tag;
import org.spout.nbt.TagType;

public class CompoundTag
extends Tag<CompoundMap> {
    private final CompoundMap value;

    public CompoundTag(String name, CompoundMap value) {
        super(TagType.TAG_COMPOUND, name);
        this.value = value;
    }

    @Override
    public CompoundMap getValue() {
        return this.value;
    }

    public String toString() {
        String name = this.getName();
        String append = "";
        if (name != null && !name.equals("")) {
            append = "(\"" + this.getName() + "\")";
        }
        StringBuilder bldr = new StringBuilder();
        bldr.append("TAG_Compound").append(append).append(": ").append(this.value.size()).append(" entries\r\n{\r\n");
        for (Tag<?> entry : this.value.values()) {
            bldr.append("   ").append(entry.toString().replaceAll("\r\n", "\r\n   ")).append("\r\n");
        }
        bldr.append("}");
        return bldr.toString();
    }

    @Override
    public CompoundTag clone() {
        CompoundMap map = new CompoundMap(this.value);
        return new CompoundTag(this.getName(), map);
    }
}

