/*
 * Decompiled with CFR 0.152.
 */
package installer;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import installer.Compress;
import installer.Extract;
import installer.FileFinder;
import installer.ImageScaler;
import installer.Menu;
import installer.MenuGUI;
import installer.OP;
import installer.Postrequest;
import installer.Read;
import installer.Start;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class Import {
    private File isport = new File(Start.sport, "Import");
    private File isportn = new File(Start.sport, "Importn");
    private File isportc = new File(Start.sport, "Importc");
    private File isportc2 = new File(Start.sport, "Importc2");
    private File isportinfo = new File(Start.sport, "ImportInfo");
    private String modName = "";
    private String modVersion = "";
    private String mcVersion = "";
    private String description = "";
    private String authors = "";
    private String website = "";
    private String credits = "";
    private String requiredMods = "";
    private String modLogo = "";
    private MenuGUI men;

    public Import(File impFile, MenuGUI men) {
        this.men = men;
        this.setImport();
        OP.del(this.isportc);
        OP.del(this.isportc2);
        OP.makedirs(this.isportn);
        OP.makedirs(this.isportc);
        if (!Menu.isModloader) {
            try {
                this.seachArchive(impFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.modName.equals("")) {
                this.description = Read.getTextwith("Import", "nomodinfo");
                this.website = String.valueOf(Read.getTextwith("installer", "website")) + "faq.php?id=nomodinfo";
                this.modName = impFile.isFile() ? impFile.getName().substring(0, impFile.getName().lastIndexOf(".")) : impFile.getName();
                File importf = new File(this.isport, String.valueOf(this.modName) + ".jar");
                try {
                    OP.copy(impFile, importf);
                }
                catch (Exception exception) {}
            } else {
                try {
                    if (!Start.sentImportedModInfo.contains(this.modName)) {
                        String body = "Name=" + this.modName.replace("'", "`") + "&" + "MCVersion=" + this.mcVersion.replace("'", "`") + "&" + "ModVersion=" + URLEncoder.encode(this.modVersion.replace("'", "`"), "UTF-8") + "&" + "Requires=" + URLEncoder.encode(this.requiredMods.replace("'", "`"), "UTF-8") + "&" + "Description=" + this.description.replace("'", "`") + "&" + "Web=" + URLEncoder.encode(this.website.replace("'", "`"), "UTF-8");
                        Start.sentImportedModInfo.add(this.modName);
                        new Postrequest("https://www.minecraft-installer.de/api/imports.php", body);
                    }
                }
                catch (Exception body) {}
            }
        } else {
            String impFileName = impFile.getName();
            this.modName = impFileName.substring(0, impFileName.lastIndexOf(46));
            File modspo = new File(this.isport, this.modName);
            modspo.mkdirs();
            if (impFile.isFile()) {
                String Dateiendung = impFile.getName().substring(impFile.getName().lastIndexOf("."));
                if (Dateiendung.equals(".jar") || Dateiendung.equals(".zip")) {
                    try {
                        new Extract(impFile, modspo);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        OP.copy(impFile, new File(modspo, impFileName));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                try {
                    OP.copy(impFile, modspo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.isport.exists()) {
            File[] imports;
            File[] fileArray = imports = this.isport.listFiles();
            int n = imports.length;
            int n2 = 0;
            while (n2 < n) {
                String name;
                File modi = fileArray[n2];
                if (!Menu.isModloader) {
                    if (modi.isFile()) {
                        name = modi.getName().substring(0, modi.getName().lastIndexOf("."));
                        this.setListEntry(name);
                    }
                } else if (modi.isDirectory()) {
                    name = modi.getName();
                    this.setListEntry(name);
                }
                ++n2;
            }
        }
        this.make(new File(this.isport, String.valueOf(this.modName) + ".jar"));
    }

    public Import(String modName, MenuGUI men) {
        this.modName = modName;
        this.men = men;
        this.setImport();
        if (!Menu.isModloader) {
            File jarfile = new File(this.isport, String.valueOf(modName) + ".jar");
            File modjsonfile = new File(this.isportinfo, String.valueOf(this.modName) + ".json");
            if (jarfile.exists()) {
                if (modjsonfile.exists()) {
                    try {
                        this.readModinfo(OP.Textreaders(modjsonfile));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else {
                    this.description = Read.getTextwith("Import", "nomodinfo");
                    this.website = String.valueOf(Read.getTextwith("installer", "website")) + "faq.php?id=nomodinfo";
                }
                this.make(jarfile);
            }
        } else {
            File[] fileArray = this.isport.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    this.make(f);
                }
                ++n2;
            }
        }
    }

    private void setImport() {
        this.men.modinstWebLnk.setVisible(false);
        this.men.modVersionL.setVisible(true);
        this.men.topIcon.setVisible(false);
        this.men.videoButton.setVisible(false);
        JLabel[] jLabelArray = this.men.ratIcons;
        int n = this.men.ratIcons.length;
        int n2 = 0;
        while (n2 < n) {
            JLabel ic = jLabelArray[n2];
            ic.setVisible(false);
            ++n2;
        }
    }

    private void seachArchive(File datei) {
        OP.del(this.isportc);
        if (datei.isFile()) {
            String Dateiendung = datei.getName().substring(datei.getName().lastIndexOf("."));
            if (Dateiendung.equals(".jar") || Dateiendung.equals(".zip")) {
                if (Dateiendung.equals(".jar")) {
                    if (this.getModinfoStringFromJAR(datei)) {
                        File importf = new File(this.isport, String.valueOf(this.modName) + ".jar");
                        try {
                            OP.copy(datei, importf);
                        }
                        catch (Exception exception) {}
                    } else {
                        this.isportc.mkdirs();
                        try {
                            new Extract(datei, this.isportc);
                            this.searchInfoFile(this.isportc);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    try {
                        this.isportc.mkdirs();
                        new Extract(datei, this.isportc);
                        this.searchInfoFile(this.isportc);
                        try {
                            File[] jars = this.searchFile(this.isportc, ".jar");
                            int j = 0;
                            while (j < jars.length) {
                                OP.del(this.isportc2);
                                new Extract(jars[j], this.isportc2);
                                this.searchInfoFile(this.isportc2);
                                ++j;
                            }
                        }
                        catch (Exception jars) {
                            // empty catch block
                        }
                        try {
                            File[] zips = this.searchFile(this.isportc, ".zip");
                            int z = 0;
                            while (z < zips.length) {
                                OP.del(this.isportc2);
                                new Extract(zips[z], this.isportc2);
                                this.searchInfoFile(this.isportc2);
                                ++z;
                            }
                        }
                        catch (Exception zips) {
                        }
                    }
                    catch (Exception zips) {}
                }
            }
        } else {
            File[] jars = this.searchFile(datei, ".jar");
            int j = 0;
            while (j < jars.length) {
                this.seachArchive(jars[j]);
                ++j;
            }
            File[] zips = this.searchFile(datei, ".zip");
            int z = 0;
            while (z < zips.length) {
                this.seachArchive(zips[z]);
                ++z;
            }
            this.searchInfoFile(datei);
        }
    }

    private void searchInfoFile(File parent) {
        File[] fileArray = parent.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.isFile()) {
                if (child.getName().endsWith(".info") && !child.getName().startsWith("dependencies")) {
                    try {
                        String cont = OP.Textreaders(child);
                        if (!cont.equals("")) {
                            this.readModinfo(cont);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    File path = new File(this.isportn, this.modName);
                    OP.del(path);
                    path.mkdirs();
                    try {
                        OP.copy(parent, path);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    new Compress(path, new File(this.isport, String.valueOf(this.modName) + ".jar"));
                }
            } else {
                this.searchInfoFile(child);
            }
            ++n2;
        }
    }

    private boolean getModinfoStringFromJAR(File jarfile) {
        String jsontext;
        StringBuilder builder;
        block16: {
            builder = new StringBuilder();
            String inputFile = "jar:file:/" + jarfile.getAbsolutePath() + "!/mcmod.info";
            InputStream in = null;
            try {
                try {
                    int ch;
                    URL inputURL = new URL(inputFile);
                    JarURLConnection conn = (JarURLConnection)inputURL.openConnection();
                    in = conn.getInputStream();
                    while ((ch = in.read()) != -1) {
                        builder.append((char)ch);
                    }
                }
                catch (Exception inputURL) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (!(jsontext = builder.toString()).equals("")) {
            return this.readModinfo(jsontext);
        }
        return false;
    }

    private boolean readModinfo(String jsontext) {
        Gson gson = new Gson();
        try {
            String neu;
            JsonArray jsona1 = null;
            JsonObject jsono1 = null;
            try {
                jsona1 = gson.fromJson(jsontext, JsonArray.class);
                jsono1 = gson.fromJson(jsona1.get(0), JsonObject.class);
            }
            catch (Exception e) {
                JsonObject jsonoa = gson.fromJson(jsontext, JsonObject.class);
                jsono1 = jsonoa.get("modList").getAsJsonArray().get(0).getAsJsonObject();
            }
            try {
                this.modName = jsono1.get("name").getAsString();
                this.isportinfo.mkdirs();
                OP.Textwriter(new File(this.isportinfo, String.valueOf(this.modName) + ".json"), jsontext, false);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.modVersion = jsono1.get("version").getAsString();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.modLogo = jsono1.get("logoFile").getAsString().replace("\\", "/");
                if (this.modLogo.startsWith("/")) {
                    this.modLogo = this.modLogo.substring(1, this.modLogo.length());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.mcVersion = jsono1.get("mcversion").getAsString();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.description = jsono1.get("description").getAsString();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                neu = "";
                JsonArray Autorena = jsono1.get("authorList").getAsJsonArray();
                int i = 0;
                while (i < Autorena.size()) {
                    neu = String.valueOf(neu) + Autorena.get(i).getAsString() + ", ";
                    ++i;
                }
                if (neu.length() > 0) {
                    this.authors = neu.substring(0, neu.length() - 2);
                }
            }
            catch (Exception e) {
                try {
                    String neu2 = "";
                    JsonArray Autorena = jsono1.get("authors").getAsJsonArray();
                    int i = 0;
                    while (i < Autorena.size()) {
                        neu2 = String.valueOf(neu2) + Autorena.get(i).getAsString() + ", ";
                        ++i;
                    }
                    if (neu2.length() > 0) {
                        this.authors = neu2.substring(0, neu2.length() - 2);
                    }
                }
                catch (Exception neu2) {
                    // empty catch block
                }
            }
            try {
                this.website = jsono1.get("url").getAsString();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.credits = jsono1.get("credits").getAsString();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                neu = "";
                JsonArray Benoetigta = jsono1.get("dependencies").getAsJsonArray();
                int i = 0;
                while (i < Benoetigta.size()) {
                    neu = String.valueOf(neu) + Benoetigta.get(i).getAsString() + ", ";
                    ++i;
                }
                if (neu.length() > 0) {
                    this.requiredMods = neu.substring(0, neu.length() - 2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void loadPic() throws IOException {
        File modpicfile;
        block20: {
            File jarfile = new File(this.isport, String.valueOf(this.modName) + ".jar");
            modpicfile = new File(this.isportinfo, String.valueOf(this.modName) + ".png");
            if (!modpicfile.exists() && jarfile.exists()) {
                modpicfile.createNewFile();
                InputStream in = null;
                Image bi = null;
                try {
                    try {
                        String inputFile = "jar:file:/" + jarfile.getAbsolutePath() + "!/" + this.modLogo;
                        URL inputURL = new URL(inputFile);
                        JarURLConnection conn = (JarURLConnection)inputURL.openConnection();
                        in = conn.getInputStream();
                        bi = ImageIO.read(in);
                        ImageIO.write((RenderedImage)((Object)bi), "png", modpicfile);
                        this.men.picture.setIcon(new ImageIcon(new ImageScaler().scaleImage((BufferedImage)bi, new Dimension(400, 225))));
                    }
                    catch (Exception exception) {
                        if (in != null) {
                            in.close();
                        }
                        if (bi != null) {
                            bi.flush();
                            bi.flush();
                        }
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        in.close();
                    }
                    if (bi != null) {
                        bi.flush();
                        bi.flush();
                    }
                    throw throwable;
                }
                if (in != null) {
                    in.close();
                }
                if (bi != null) {
                    bi.flush();
                    bi.flush();
                }
            }
        }
        if (modpicfile.exists() && modpicfile.length() > 10L) {
            BufferedImage bi = null;
            try {
                try {
                    bi = ImageIO.read(modpicfile);
                    this.men.picture.setIcon(new ImageIcon(new ImageScaler().scaleImage(bi, new Dimension(400, 225))));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (bi != null) {
                        bi.flush();
                        bi.flush();
                    }
                }
            }
            finally {
                if (bi != null) {
                    bi.flush();
                    bi.flush();
                }
            }
        }
    }

    private void setListEntry(String name) {
        if (!this.men.rightListModel.contains("+ " + name)) {
            this.men.nextButton.setEnabled(true);
            this.men.rightListModel.addElement("+ " + name);
            this.men.rightList.setSelectedIndex(this.men.rightListModel.size() - 1);
        }
    }

    private File[] searchFile(File ordner, String suche) {
        FileFinder ff = new FileFinder();
        ff.sucheDatei(suche, ordner, null);
        File[] fs = new File[ff.findings.size()];
        int i = 0;
        while (i < ff.findings.size()) {
            fs[i] = ff.findings.get(i);
            ++i;
        }
        return fs;
    }

    private void make(File jarfile) {
        if (!this.modLogo.equals("")) {
            JLabel bild = new JLabel();
            bild.setHorizontalAlignment(0);
        }
        try {
            this.loadPic();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File modpicfile = new File(this.isportinfo, String.valueOf(this.modName) + ".png");
        if (modpicfile.length() < 10L) {
            this.men.picture.setIcon(new ImageIcon(this.getClass().getResource("src/mods.png")));
        }
        this.men.website = this.website;
        this.men.modNameLabel.setText(this.modName);
        if (!Menu.isModloader) {
            this.men.sizeLabel.setText(new OP().getSizeAsString(jarfile.length()));
            if (!this.modVersion.equals("")) {
                this.men.modVersionL.setText("Mod v. " + this.modVersion);
            } else {
                this.men.modVersionL.setText("Forge Mod");
            }
        } else {
            this.description = Read.getTextwith("Menu", "importm");
            this.men.website = String.valueOf(Read.getTextwith("installer", "website")) + "faq.php?id=importm";
            this.men.modVersionL.setText("Modloader Mod");
        }
        String text = "<html><body>";
        if (!this.mcVersion.equals("") && !this.mcVersion.contains(Start.mcVersion)) {
            text = String.valueOf(text) + Read.getTextwith("Import", "warning1") + this.mcVersion + "!</b><br><br>";
        }
        text = String.valueOf(text) + this.description + "<br><br>";
        if (!this.requiredMods.equals("")) {
            text = String.valueOf(text) + "<b>" + Read.getTextwith("Import", "requiredMods") + "</b>: " + this.requiredMods + "<br><br>";
        }
        if (!this.authors.equals("")) {
            text = String.valueOf(text) + "<b>" + Read.getTextwith("Import", "authors") + "</b>: " + this.authors + "<br><br>";
        }
        if (!this.credits.equals("")) {
            text = String.valueOf(text) + "<b>" + Read.getTextwith("Import", "credits") + "</b>: " + this.credits + "<br><br>";
        }
        text = text.substring(0, text.length() - 8);
        this.men.modDescPane.setText(text);
    }
}

