/*
 * Decompiled with CFR 0.152.
 */
package installer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import installer.Downloader;
import installer.Error;
import installer.License;
import installer.MCVersion;
import installer.MCVersions;
import installer.Modinfo;
import installer.OP;
import installer.OperatingSystem;
import installer.Postrequest;
import installer.Read;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class Start
extends JFrame {
    private static final long serialVersionUID = 6893761562923644768L;
    private JLabel modinstallerVersionLabel = new JLabel();
    private JLabel prog = new JLabel();
    private JLabel logo = new JLabel();
    private JPanel cp;
    private String versionExtension;
    private int tryno = 0;
    private int heightFrame = 300;
    private int widthFrame = 500;
    public static ArrayList<String> offlineList = new ArrayList();
    public static Modinfo[] modtexts = null;
    public static Modinfo[] moddownloads = null;
    public static String mcVersion = "";
    public static String webplace;
    public static String lang;
    public static String modinstallerVersion;
    public static File mineord;
    public static File sport;
    public static ArrayList<String> sentImportedModInfo;
    public static String[] mcVersionen;
    public static MCVersion[] allMCVersions;
    public static MCVersion[] forgeMCVersions;
    public static boolean online;

    static {
        lang = "en";
        modinstallerVersion = "";
        sentImportedModInfo = new ArrayList();
        online = false;
    }

    public static void main(String[] args) {
        System.setProperty("java.net.preferIPv4Stack", "true");
        try {
            Color red = Color.decode("#9C2717");
            Color white = Color.decode("#FFFfff");
            Color darkwhite = Color.decode("#eFe9d9");
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
            UIManager.put("nimbusBase", white);
            UIManager.put("text", red);
            UIManager.put("info", white);
            UIManager.put("nimbusSelectionBackground", red);
            UIManager.put("nimbusSelectedText", white);
            UIManager.put("nimbusFocus", darkwhite);
            UIManager.put("nimbusLightBackground", white);
            UIManager.put("control", white);
            UIManager.getLookAndFeelDefaults().put("List[Selected].textBackground", red);
            UIManager.getLookAndFeelDefaults().put("List[Selected].textForeground", white);
        }
        catch (Exception e) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        new Start();
    }

    public Start() {
        this.getMCDir();
        lang = !OP.optionReader("language").equals("n/a") ? OP.optionReader("language") : (System.getProperty("user.language").startsWith("de") ? "de" : "en");
        modinstallerVersion = Read.getTextwith("installer", "version");
        this.versionExtension = Read.getTextwith("installer", "zusatz");
        webplace = Read.getTextwith("installer", "webplace");
        if (!OP.optionReader("modinstaller").equals(modinstallerVersion)) {
            OP.del(sport);
            OP.del(new File(String.valueOf(System.getProperty("user.home")) + "/Desktop/MC Modinstaller 4.1.lnk"));
            OP.del(new File(String.valueOf(System.getProperty("user.home")) + "/Microsoft/Windows/Start Menu/Programs/MC Modinstaller 4.1.lnk"));
            OP.del(new File(String.valueOf(System.getProperty("user.home")) + "/Desktop/MC Modinstaller 4.2.lnk"));
            OP.del(new File(String.valueOf(System.getProperty("user.home")) + "/Microsoft/Windows/Start Menu/Programs/MC Modinstaller 4.2.lnk"));
            OP.del(new File(String.valueOf(System.getProperty("user.home")) + "/Desktop/MC Modinstaller 4.3.lnk"));
            OP.del(new File(String.valueOf(System.getProperty("user.home")) + "/Microsoft/Windows/Start Menu/Programs/MC Modinstaller 4.3.lnk"));
            OP.del(new File(String.valueOf(System.getProperty("user.home")) + "/Desktop/MC Modinstaller 4.4.lnk"));
            OP.del(new File(String.valueOf(System.getProperty("user.home")) + "/Microsoft/Windows/Start Menu/Programs/MC Modinstaller 4.4.lnk"));
            OP.del(new File(String.valueOf(System.getProperty("user.home")) + "/Desktop/MC Modinstaller 4.5.lnk"));
            OP.del(new File(String.valueOf(System.getProperty("user.home")) + "/Microsoft/Windows/Start Menu/Programs/MC Modinstaller 4.5.lnk"));
        }
        OP.makedirs(sport);
        OP.optionWriter("language", lang);
        OP.optionWriter("modinstaller", modinstallerVersion);
        this.setSize(this.widthFrame, this.heightFrame);
        this.setUndecorated(true);
        this.setTitle(Read.getTextwith("installer", "name"));
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setIconImage(new ImageIcon(this.getClass().getResource("src/icon.png")).getImage());
        this.cp = new JPanel();
        this.cp.setBackground(Color.white);
        this.cp.setBorder(BorderFactory.createLineBorder(Color.decode("#9C2717")));
        this.cp.setLayout(null);
        this.add(this.cp);
        this.modinstallerVersionLabel.setBounds(this.widthFrame - 150 - 15, 15, 150, 20);
        this.modinstallerVersionLabel.setText("Version " + modinstallerVersion + " " + this.versionExtension);
        this.modinstallerVersionLabel.setFont(new Font("Arial", 0, 14));
        this.modinstallerVersionLabel.setHorizontalAlignment(4);
        this.cp.add(this.modinstallerVersionLabel);
        this.logo.setBounds(0, 0, this.widthFrame, this.heightFrame - 50);
        this.logo.setIcon(new ImageIcon(this.getClass().getResource("src/logok.png")));
        this.logo.setHorizontalAlignment(0);
        this.cp.add(this.logo);
        this.prog.setBounds(220, 250, 350, 20);
        this.prog.setText(Read.getTextwith("Start", "prog1"));
        this.prog.setFont(new Font("Dialog", 1, 16));
        this.cp.add(this.prog);
        this.setVisible(true);
        new Thread(){

            @Override
            public void run() {
                OP.del(new File(sport, "zusatz.txt"));
                OP.del(new File(sport, "Importn"));
                OP.del(new File(sport, "modlist.txt"));
                Start.this.searchMCVersions();
                online = Start.this.checkInstallerUpdate();
                if (online) {
                    Start.this.makeShortcuts();
                    Start.this.downloadReqInfo();
                }
                Start.this.askMCVersion();
            }
        }.start();
    }

    private void makeShortcuts() {
        try {
            String str = System.getProperty("os.name").toLowerCase();
            File installerf = new File(sport, "MCModinstaller.exe");
            if (str.contains("win") && (!installerf.exists() || installerf.length() < 102400L)) {
                int len;
                if (!installerf.exists() || installerf.length() < 102400L) {
                    String downlaodexestr = "http://www.minecraft-installer.de/Dateien/Programme/MC%20Modinstaller%20" + modinstallerVersion + ".exe";
                    new Downloader(downlaodexestr, installerf).run();
                }
                InputStream inputStream = this.getClass().getResourceAsStream("src/links.vbs");
                File tempOutputFile = File.createTempFile("links", ".vbs");
                tempOutputFile.deleteOnExit();
                FileOutputStream out = new FileOutputStream(tempOutputFile);
                byte[] buffer = new byte[1024];
                while ((len = inputStream.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
                out.close();
                inputStream.close();
                Desktop.getDesktop().open(tempOutputFile);
            }
        }
        catch (Exception ex) {
            new Error(OP.getError(ex));
        }
    }

    private void getMCDir() {
        File stamm;
        String str = System.getProperty("os.name").toLowerCase();
        if (str.contains("win")) {
            mineord = new File(System.getenv("APPDATA").replace("\\", File.separator), ".minecraft");
            stamm = new File(System.getenv("APPDATA").replace("\\", File.separator));
        } else if (str.contains("mac")) {
            mineord = new File(System.getProperty("user.home").replace("\\", File.separator), "Library/Application Support/minecraft");
            stamm = new File(System.getProperty("user.home").replace("\\", File.separator), "Library/Application Support");
        } else {
            mineord = new File(System.getProperty("user.home").replace("\\", File.separator), ".minecraft");
            stamm = new File(System.getProperty("user.home").replace("\\", File.separator));
        }
        sport = new File(stamm, "Modinstaller");
    }

    private boolean checkInstallerUpdate() {
        this.prog.setText(Read.getTextwith("Start", "prog4"));
        try {
            File updatetxt = new File(sport, "update.txt");
            String quellenurl = "https://www.minecraft-installer.de/api/counter.php?target=update&lang=" + lang;
            new Downloader(quellenurl, updatetxt).run();
            if (updatetxt.exists()) {
                String[] cont = OP.Textreader(updatetxt);
                if (cont.length < 0) {
                    new Downloader(quellenurl, updatetxt).run();
                    cont = OP.Textreader(updatetxt);
                }
                if (cont.length > 0) {
                    boolean newVersAvail = false;
                    String newVers = "";
                    try {
                        String currVers = modinstallerVersion;
                        newVers = cont[0];
                        String s1 = this.normalisedVersion(currVers);
                        String s2 = this.normalisedVersion(newVers);
                        int cmp = s1.compareTo(s2);
                        if (cmp < 0) {
                            newVersAvail = true;
                        }
                    }
                    catch (Exception e) {
                        String body = "Text=" + OP.getError(e) + "; Errorcode: S1x04a&MCVers=" + mcVersion + "&InstallerVers=" + Read.getTextwith("installer", "version") + "&OP=" + System.getProperty("os.name").toString() + "; " + System.getProperty("os.version").toString() + "; " + System.getProperty("os.arch").toString() + "&EMail=unkn";
                        new Postrequest("https://www.minecraft-installer.de/api/errorreceiver.php", body);
                    }
                    if (newVersAvail) {
                        this.prog.setText(Read.getTextwith("Start", "prog5"));
                        String desc = "";
                        int i = 1;
                        while (i < cont.length) {
                            desc = String.valueOf(desc) + cont[i];
                            ++i;
                        }
                        int eingabe = JOptionPane.showConfirmDialog(null, "<html><body><span style=\"font-weight:bold\">" + Read.getTextwith("Start", "update1") + newVers + Read.getTextwith("Start", "update2") + desc + Read.getTextwith("Start", "update3"), Read.getTextwith("Start", "update1"), 0);
                        if (eingabe == 0) {
                            OperatingSystem.openLink(Read.getTextwith("installer", "website"));
                        }
                    } else {
                        this.prog.setText(Read.getTextwith("Start", "prog6"));
                    }
                } else {
                    new IllegalStateException("Update file cannot be downloaded correctly");
                }
            }
            online = true;
            OP.del(updatetxt);
        }
        catch (Exception ex) {
            if (this.tryno < 2) {
                ++this.tryno;
                return this.checkInstallerUpdate();
            }
            online = false;
            Object[] options2 = new Object[]{Read.getTextwith("Start", "inter1"), Read.getTextwith("Start", "inter2"), Read.getTextwith("Start", "inter3")};
            int selected2 = JOptionPane.showOptionDialog(null, String.valueOf(Read.getTextwith("Start", "inter4")) + ex.toString(), Read.getTextwith("Start", "inter4h"), -1, 3, null, options2, options2[0]);
            switch (selected2) {
                case 0: {
                    OperatingSystem.openLink(Read.getTextwith("Start", "intercon"));
                    break;
                }
                case 2: {
                    System.exit(0);
                }
            }
            try {
                String body = "Text=" + OP.getError(ex) + "; Errorcode: S1x04&MCVers=" + mcVersion + "&InstallerVers=" + Read.getTextwith("installer", "version") + "&OP=" + System.getProperty("os.name").toString() + "; " + System.getProperty("os.version").toString() + "; " + System.getProperty("os.arch").toString() + "&EMail=unkn";
                new Postrequest("https://www.minecraft-installer.de/api/error.php", body);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return online;
    }

    private void searchMCVersions() {
        File file = new File(mineord, "versions");
        if (file.exists()) {
            File[] li = file.listFiles();
            int i = 0;
            while (i < li.length) {
                File jarfile = new File(li[i], String.valueOf(li[i].getName()) + ".jar");
                File jsonfile = new File(li[i], String.valueOf(li[i].getName()) + ".json");
                if (jarfile.exists() && jsonfile.exists() && !li[i].getName().equals("Modinstaller")) {
                    offlineList.add(li[i].getName());
                }
                ++i;
            }
        }
    }

    private void downloadReqInfo() {
        if (online) {
            block15: {
                String jsontext;
                Gson gson;
                try {
                    this.prog.setText(Read.getTextwith("Start", "prog12"));
                    File texte = new File(sport, "modtexts.json");
                    new Downloader("https://www.minecraft-installer.de/api/mods2.php", texte).run();
                    if (texte.exists()) {
                        gson = new Gson();
                        jsontext = OP.Textreaders(texte);
                        modtexts = gson.fromJson(jsontext, Modinfo[].class);
                        OP.del(texte);
                    }
                }
                catch (Exception e) {
                    new Error(OP.getError(e));
                }
                try {
                    this.prog.setText(Read.getTextwith("Start", "prog13"));
                    File downloadt = new File(sport, "downloadtexts.json");
                    new Downloader("https://www.minecraft-installer.de/api/offer3.php", downloadt).run();
                    if (downloadt.exists()) {
                        gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
                        jsontext = OP.Textreaders(downloadt);
                        moddownloads = gson.fromJson(jsontext, Modinfo[].class);
                        OP.del(downloadt);
                    }
                }
                catch (Exception e) {
                    new Error(OP.getError(e));
                }
                try {
                    File mcversions = new File(sport, "mcversions.json");
                    new Downloader("https://www.minecraft-installer.de/api/mcversions.php", mcversions).run();
                    if (!mcversions.exists()) break block15;
                    gson = new Gson();
                    try {
                        jsontext = OP.Textreaders(mcversions);
                        allMCVersions = gson.fromJson(jsontext, MCVersion[].class);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ArrayList<MCVersion> fmv = new ArrayList<MCVersion>();
                    MCVersion[] mCVersionArray = allMCVersions;
                    int n = allMCVersions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MCVersion allmcv = mCVersionArray[n2];
                        if (allmcv.getSumForge() > 2) {
                            fmv.add(allmcv);
                        }
                        ++n2;
                    }
                    forgeMCVersions = fmv.toArray(new MCVersion[fmv.size()]);
                    OP.del(mcversions);
                }
                catch (Exception e) {
                    new Error(OP.getError(e));
                }
            }
            try {
                File backgr = new File(sport, "modinstallerbg.png");
                new Downloader("https://www.minecraft-installer.de/Dateien/modinstallerbg.png", backgr).run();
            }
            catch (Exception e) {
                new Error(OP.getError(e));
            }
        }
    }

    private void askMCVersion() {
        this.prog.setText(Read.getTextwith("Start", "prog14"));
        String lizenz = OP.optionReader("license");
        if (lizenz.equals("n/a") || lizenz.equals("false")) {
            new License();
        } else {
            new MCVersions();
        }
        this.dispose();
    }

    private String normalisedVersion(String version) {
        return this.normalisedVersion(version, ".", 4);
    }

    private String normalisedVersion(String version, String sep, int maxWidth) {
        String[] split = Pattern.compile(sep, 16).split(version);
        StringBuilder sb = new StringBuilder();
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(String.format("%" + maxWidth + 's', s));
            ++n2;
        }
        return sb.toString();
    }
}

