/*
 * Decompiled with CFR 0.152.
 */
package org.spout.nbt;

import org.spout.nbt.CompoundMap;
import org.spout.nbt.Tag;

public final class CompoundTag
extends Tag {
    private final CompoundMap value;

    public CompoundTag(String name, CompoundMap value) {
        super(name);
        this.value = value;
    }

    @Override
    public CompoundMap getValue() {
        return this.value;
    }

    public String toString() {
        String name = this.getName();
        String append = "";
        if (name != null && !name.equals("")) {
            append = "(\"" + this.getName() + "\")";
        }
        StringBuilder bldr = new StringBuilder();
        bldr.append("TAG_Compound").append(append).append(": ").append(this.value.size()).append(" entries\r\n{\r\n");
        for (Tag entry : this.value.values()) {
            bldr.append("   ").append(entry.getValue().toString().replaceAll("\r\n", "\r\n   ")).append("\r\n");
        }
        bldr.append("}");
        return bldr.toString();
    }

    @Override
    public CompoundTag clone() {
        CompoundMap map = new CompoundMap(this.value);
        return new CompoundTag(this.getName(), map);
    }
}

