/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.Install;
import installer.OP;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class Extract {
    private File archive;
    private File destDir;
    private double max = 100.0;
    private double start = 0.0;

    public Extract(File archive, File destDir, double max, double start) throws Exception {
        this.archive = archive;
        this.destDir = destDir;
        this.max = max;
        this.start = start;
        this.work();
    }

    public Extract(File archive, File destDir) throws Exception {
        this.archive = archive;
        this.destDir = destDir;
        this.work();
    }

    private void work() throws ZipException, IOException {
        this.destDir.mkdir();
        try (ZipFile zipFile = null;){
            zipFile = new ZipFile(this.archive);
            double add = this.max / (double)zipFile.size();
            double val = this.start;
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            byte[] buffer = new byte[4096];
            ZipEntry entry = null;
            while (entries.hasMoreElements()) {
                File dir;
                entry = entries.nextElement();
                String entryFileName = entry.getName();
                if (entryFileName.equals("aux.class")) {
                    entryFileName = "_aux.class";
                }
                if (!(dir = this.buildDirectoryHierarchyFor(entryFileName, this.destDir)).exists()) {
                    dir.mkdirs();
                }
                if (entry.isDirectory() || entryFileName.endsWith(".") || entryFileName.endsWith("..")) continue;
                FileOutputStream fos = null;
                BufferedOutputStream bos = null;
                BufferedInputStream bis = null;
                try {
                    int len;
                    fos = new FileOutputStream(new File(this.destDir, entryFileName));
                    bos = new BufferedOutputStream(fos);
                    bis = new BufferedInputStream(zipFile.getInputStream(entry));
                    while ((len = bis.read(buffer)) > 0) {
                        bos.write(buffer, 0, len);
                    }
                    Install.detState(val += add);
                }
                finally {
                    if (bos != null) {
                        bos.flush();
                        bos.close();
                    }
                    if (bis != null) {
                        bis.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
            }
        }
        OP.del(new File(this.destDir + "/META-INF"));
        Install.detState(this.max);
    }

    private File buildDirectoryHierarchyFor(String entryName, File destDir) {
        int lastIndex = entryName.lastIndexOf(47);
        String internalPathToEntry = entryName.substring(0, lastIndex + 1);
        return new File(destDir, internalPathToEntry);
    }
}

