/*
 * Decompiled with CFR 0.152.
 */
package argo.staj;

import argo.staj.JsonStreamException;
import argo.staj.ThingWithPosition;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;

final class PositionTrackingPushbackReader
implements ThingWithPosition {
    private static final int NEWLINE = 10;
    private static final int CARRIAGE_RETURN = 13;
    private final PushbackReader pushbackReader;
    private int characterCount = 0;
    private int lineCount = 1;
    private boolean lastCharacterWasCarriageReturn = false;

    PositionTrackingPushbackReader(Reader in) {
        this.pushbackReader = new PushbackReader(in);
    }

    void unread(char c) throws JsonStreamException {
        --this.characterCount;
        if (this.characterCount < 0) {
            this.characterCount = 0;
        }
        try {
            this.pushbackReader.unread(c);
        }
        catch (IOException e) {
            throw new JsonStreamException("Failed to read from Reader", e);
        }
    }

    void uncount(char[] resultCharArray) {
        this.characterCount -= resultCharArray.length;
        if (this.characterCount < 0) {
            this.characterCount = 0;
        }
    }

    int read() throws JsonStreamException {
        try {
            int result = this.pushbackReader.read();
            this.updateCharacterAndLineCounts(result);
            return result;
        }
        catch (IOException e) {
            throw new JsonStreamException("Failed to read from Reader", e);
        }
    }

    int read(char[] buffer) throws JsonStreamException {
        try {
            int result = this.pushbackReader.read(buffer);
            for (char character : buffer) {
                this.updateCharacterAndLineCounts(character);
            }
            return result;
        }
        catch (IOException e) {
            throw new JsonStreamException("Failed to read from Reader", e);
        }
    }

    private void updateCharacterAndLineCounts(int result) {
        if (13 == result) {
            this.characterCount = 0;
            ++this.lineCount;
            this.lastCharacterWasCarriageReturn = true;
        } else {
            if (10 == result && !this.lastCharacterWasCarriageReturn) {
                this.characterCount = 0;
                ++this.lineCount;
            } else {
                ++this.characterCount;
            }
            this.lastCharacterWasCarriageReturn = false;
        }
    }

    public int getColumn() {
        return this.characterCount;
    }

    public int getRow() {
        return this.lineCount;
    }

    public ThingWithPosition snapshotOfPosition() {
        return new ThingWithPosition(){
            private final int localCharacterCount;
            private final int localLineCount;
            {
                this.localCharacterCount = PositionTrackingPushbackReader.this.characterCount;
                this.localLineCount = PositionTrackingPushbackReader.this.lineCount;
            }

            public int getColumn() {
                return this.localCharacterCount;
            }

            public int getRow() {
                return this.localLineCount;
            }
        };
    }
}

