/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.Read;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;

public class OP {
    public boolean del(File dir) {
        if (dir.exists()) {
            File f = dir;
            if (f.isDirectory()) {
                File[] files;
                File[] fileArray = files = f.listFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File aktFile = fileArray[n2];
                    this.del(aktFile);
                    ++n2;
                }
            }
            return f.delete();
        }
        return false;
    }

    public void copy(File quelle, File ziel) throws FileNotFoundException, IOException {
        if (quelle.exists()) {
            if (quelle.isDirectory()) {
                this.makedirs(ziel);
                this.copyDir(quelle, ziel);
            } else {
                this.makedirs(ziel.getParentFile());
                OP.copyFile(quelle, ziel);
            }
        }
    }

    public static void copyFile(File source, File target) throws IOException {
        if (!target.exists()) {
            target.createNewFile();
        }
        FileChannel sourceChannel = null;
        AbstractInterruptibleChannel targetChannel = null;
        try {
            sourceChannel = new FileInputStream(source).getChannel();
            targetChannel = new FileOutputStream(target).getChannel();
            ((FileChannel)targetChannel).transferFrom(sourceChannel, 0L, sourceChannel.size());
        }
        finally {
            if (sourceChannel != null) {
                sourceChannel.close();
            }
            if (targetChannel != null) {
                targetChannel.close();
            }
        }
    }

    public static void transfer(FileChannel inputChannel, ByteChannel outputChannel, long lengthInBytes, long chunckSizeInBytes, boolean verbose) throws IOException {
        long overallBytesTransfered = 0L;
        long time = -System.currentTimeMillis();
        while (overallBytesTransfered < lengthInBytes) {
            long bytesToTransfer = Math.min(chunckSizeInBytes, lengthInBytes - overallBytesTransfered);
            long bytesTransfered = inputChannel.transferTo(overallBytesTransfered, bytesToTransfer, outputChannel);
            overallBytesTransfered += bytesTransfered;
            if (!verbose) continue;
            long percentageOfOverallBytesTransfered = Math.round((double)overallBytesTransfered / (double)lengthInBytes * 100.0);
            System.out.printf("overall bytes transfered: %s progress %s%%\n", overallBytesTransfered, percentageOfOverallBytesTransfered);
        }
        time += System.currentTimeMillis();
        if (verbose) {
            double kiloBytesPerSecond = (double)overallBytesTransfered / 1024.0 / ((double)time / 1000.0);
            System.out.printf("Transfered: %s bytes in: %s s -> %s kbytes/s", overallBytesTransfered, time / 1000L, kiloBytesPerSecond);
        }
    }

    public void copyDir(File quelle, File ziel) throws FileNotFoundException, IOException {
        File[] files = quelle.listFiles();
        ziel.mkdirs();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.copyDir(file, new File(String.valueOf(ziel.getAbsolutePath()) + System.getProperty("file.separator") + file.getName()));
            } else {
                OP.copyFile(file, new File(String.valueOf(ziel.getAbsolutePath()) + System.getProperty("file.separator") + file.getName()));
            }
            ++n2;
        }
    }

    public void rename(File alt, File neu) throws FileNotFoundException, IOException {
        alt.renameTo(neu);
    }

    public void makedirs(File f) {
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public String version(String mineord, String Version2, String webplace, boolean online, String stamm) {
        File file = new File(String.valueOf(mineord) + "/versions");
        if (file.exists()) {
            File[] l = file.listFiles();
            int laeng = l.length;
            int i = 0;
            while (i < l.length) {
                String[] Versionx1 = l[i].getName().split("\\.");
                if (Versionx1.length != 3) {
                    --laeng;
                } else {
                    String regex = "^\\d+$";
                    boolean ok = true;
                    int i2 = 0;
                    while (i2 < Versionx1.length) {
                        String search = Versionx1[i2];
                        Pattern pattern = Pattern.compile(regex);
                        Matcher matcher = pattern.matcher(search);
                        if (!matcher.find()) {
                            ok = false;
                        }
                        ++i2;
                    }
                    if (!ok) {
                        --laeng;
                    }
                }
                ++i;
            }
            if (laeng <= 0) {
                JOptionPane.showMessageDialog(null, Read.getTextwith("OP", "error2"), Read.getTextwith("OP", "error2h"), 0);
                try {
                    Desktop.getDesktop().open(new File(String.valueOf(mineord) + "/versions"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.exit(0);
            }
            Object[] ne = new String[laeng];
            int z = 0;
            int j = 0;
            while (j < l.length) {
                String[] Versionx2 = l[j].getName().split("\\.");
                if (Versionx2.length == 3) {
                    String regex = "^\\d+$";
                    boolean ok2 = true;
                    int i3 = 0;
                    while (i3 < Versionx2.length) {
                        String search2 = Versionx2[i3];
                        Pattern pattern2 = Pattern.compile(regex);
                        Matcher matcher = pattern2.matcher(search2);
                        if (!matcher.find()) {
                            ok2 = false;
                        }
                        ++i3;
                    }
                    if (ok2) {
                        ne[z] = l[j].getName();
                        ++z;
                    }
                }
                ++j;
            }
            if (laeng < 1) {
                Version2 = null;
            } else if (laeng == 1) {
                Version2 = ne[0];
            } else {
                Object[] options = ne;
                int selected = JOptionPane.showOptionDialog(null, Read.getTextwith("OP", "modver"), Read.getTextwith("OP", "modverh"), -1, 3, null, options, options[0]);
                Version2 = selected != -1 ? ne[selected] : ne[ne.length - 1];
            }
        } else {
            JOptionPane.showMessageDialog(null, String.valueOf(Read.getTextwith("OP", "error")) + ":\n\n" + mineord + "/versions", Read.getTextwith("OP", "errorh"), 0);
            try {
                Desktop.getDesktop().open(new File(mineord));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.exit(0);
        }
        return Version2;
    }
}

