/*
 * Decompiled with CFR 0.152.
 */
package argo.jdom;

import argo.jdom.JsonField;
import argo.jdom.JsonFieldBuilder;
import argo.jdom.JsonNodeBuilder;
import argo.jdom.JsonNodeFactories;
import argo.jdom.JsonRootNode;
import argo.jdom.JsonStringNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonObjectNodeBuilder
implements JsonNodeBuilder<JsonRootNode> {
    private final FieldCollector fieldCollector;

    static JsonObjectNodeBuilder duplicateFieldPermittingJsonObjectNodeBuilder() {
        return new JsonObjectNodeBuilder(new FieldCollector(){
            private final List<JsonFieldBuilder> fieldBuilders = new LinkedList<JsonFieldBuilder>();

            @Override
            public void add(JsonFieldBuilder jsonFieldBuilder) {
                this.fieldBuilders.add(jsonFieldBuilder);
            }

            @Override
            public Iterator<JsonField> iterator() {
                final Iterator<JsonFieldBuilder> delegate = this.fieldBuilders.iterator();
                return new Iterator<JsonField>(){

                    @Override
                    public boolean hasNext() {
                        return delegate.hasNext();
                    }

                    @Override
                    public JsonField next() {
                        return ((JsonFieldBuilder)delegate.next()).build();
                    }

                    @Override
                    public void remove() {
                        delegate.remove();
                    }
                };
            }
        });
    }

    static JsonObjectNodeBuilder duplicateFieldRejectingJsonObjectNodeBuilder() {
        return new JsonObjectNodeBuilder(new FieldCollector(){
            private final Map<JsonStringNode, JsonFieldBuilder> fieldBuilders = new LinkedHashMap<JsonStringNode, JsonFieldBuilder>();

            @Override
            public void add(JsonFieldBuilder jsonFieldBuilder) {
                JsonStringNode key = jsonFieldBuilder.buildKey();
                if (this.fieldBuilders.containsKey(key)) {
                    throw new IllegalArgumentException("Attempt to add a field with pre-existing key [" + key + "]");
                }
                this.fieldBuilders.put(key, jsonFieldBuilder);
            }

            @Override
            public Iterator<JsonField> iterator() {
                final Iterator<Map.Entry<JsonStringNode, JsonFieldBuilder>> delegate = this.fieldBuilders.entrySet().iterator();
                return new Iterator<JsonField>(){

                    @Override
                    public boolean hasNext() {
                        return delegate.hasNext();
                    }

                    @Override
                    public JsonField next() {
                        return ((JsonFieldBuilder)((Map.Entry)delegate.next()).getValue()).build();
                    }

                    @Override
                    public void remove() {
                        delegate.remove();
                    }
                };
            }
        });
    }

    private JsonObjectNodeBuilder(FieldCollector fieldCollector) {
        this.fieldCollector = fieldCollector;
    }

    public JsonObjectNodeBuilder withField(String name, JsonNodeBuilder value) {
        return this.withField(JsonNodeFactories.string(name), value);
    }

    public JsonObjectNodeBuilder withField(JsonStringNode name, JsonNodeBuilder value) {
        return this.withFieldBuilder(JsonFieldBuilder.aJsonFieldBuilder().withKey(name).withValue(value));
    }

    public JsonObjectNodeBuilder withFieldBuilder(JsonFieldBuilder jsonFieldBuilder) {
        this.fieldCollector.add(jsonFieldBuilder);
        return this;
    }

    @Override
    public JsonRootNode build() {
        return JsonNodeFactories.object((Iterable<JsonField>)new ArrayList<JsonField>(){
            {
                for (JsonField field : JsonObjectNodeBuilder.this.fieldCollector) {
                    this.add(field);
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface FieldCollector
    extends Iterable<JsonField> {
        public void add(JsonFieldBuilder var1);
    }
}

