/*
 * Decompiled with CFR 0.152.
 */
package installer;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public enum OperatingSystem {
    LINUX("linux", "linux", "unix"),
    WINDOWS("windows", "win"),
    OSX("osx", "mac"),
    UNKNOWN("unknown", new String[0]);

    private final String name;
    private final String[] aliases;

    private OperatingSystem(String name, String ... aliases) {
        this.name = name;
        this.aliases = aliases == null ? new String[]{} : aliases;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public boolean isSupported() {
        return this != UNKNOWN;
    }

    public String getJavaDir() {
        String separator = System.getProperty("file.separator");
        String path = String.valueOf(System.getProperty("java.home")) + separator + "bin" + separator;
        if (OperatingSystem.getCurrentPlatform() == WINDOWS && new File(String.valueOf(path) + "javaw.exe").isFile()) {
            return String.valueOf(path) + "javaw.exe";
        }
        return String.valueOf(path) + "java";
    }

    public static OperatingSystem getCurrentPlatform() {
        String osName = System.getProperty("os.name").toLowerCase();
        OperatingSystem[] operatingSystemArray = OperatingSystem.values();
        int n = operatingSystemArray.length;
        int n2 = 0;
        while (n2 < n) {
            OperatingSystem os = operatingSystemArray[n2];
            String[] stringArray = os.getAliases();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String alias = stringArray[n4];
                if (osName.contains(alias)) {
                    return os;
                }
                ++n4;
            }
            ++n2;
        }
        return UNKNOWN;
    }

    public static void openLink(String lnk) {
        block6: {
            try {
                URI link = new URI(lnk);
                try {
                    Class<?> desktopClass = Class.forName("java.awt.Desktop");
                    Object o = desktopClass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                    desktopClass.getMethod("browse", URI.class).invoke(o, link);
                }
                catch (Throwable e) {
                    if (OperatingSystem.getCurrentPlatform() != OSX) break block6;
                    try {
                        Runtime.getRuntime().exec(new String[]{"/usr/bin/open", link.toString()});
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (URISyntaxException e2) {
                e2.printStackTrace();
            }
        }
    }

    public static void openFolder(File path) {
        String absolutePath = path.getAbsolutePath();
        OperatingSystem os = OperatingSystem.getCurrentPlatform();
        if (os == OSX) {
            try {
                Runtime.getRuntime().exec(new String[]{"/usr/bin/open", absolutePath});
                return;
            }
            catch (IOException iOException) {}
        } else if (os == WINDOWS) {
            String cmd = String.format("cmd.exe /C start \"Open file\" \"%s\"", absolutePath);
            try {
                Runtime.getRuntime().exec(cmd);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            Object desktop = desktopClass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            desktopClass.getMethod("browse", URI.class).invoke(desktop, path.toURI());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

