/*
 * Decompiled with CFR 0.152.
 */
package installer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class Downloader
implements Runnable {
    private String url_str;
    private File targetFile;
    private int expectedDownloadSize = -1;
    private long elapsed = -1L;
    private float elapsedSeconds = -1.0f;
    private float kbRead = -1.0f;
    boolean work = false;

    public Downloader(String url_str, File targetFile) {
        this.url_str = url_str;
        this.targetFile = targetFile;
    }

    @Override
    public void run() {
        do {
            try {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                HostnameVerifier allHostsValid = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
                HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
                URL url = new URL(this.url_str.replace(" ", "%20"));
                URLConnection conn = url.openConnection();
                conn.setUseCaches(false);
                conn.setDefaultUseCaches(false);
                conn.setRequestProperty("Cache-Control", "no-store,max-age=0,no-cache");
                conn.setRequestProperty("Expires", "0");
                conn.setRequestProperty("Pragma", "no-cache");
                conn.setConnectTimeout(10000);
                conn.setReadTimeout(10000);
                this.expectedDownloadSize = conn.getContentLength();
                long start = System.nanoTime();
                conn.connect();
                this.elapsed = System.nanoTime() - start;
                int responseCode = ((HttpURLConnection)conn).getResponseCode() / 100;
                if (responseCode == 2 || responseCode == 3) {
                    InputStream is = conn.getInputStream();
                    this.targetFile.getParentFile().mkdirs();
                    if (!this.targetFile.exists()) {
                        this.targetFile.createNewFile();
                    }
                    FileOutputStream os = new FileOutputStream(this.targetFile);
                    long startDownload = System.nanoTime();
                    long bytesRead = 0L;
                    byte[] buffer = new byte[65536];
                    try {
                        int read = is.read(buffer);
                        while (read >= 1) {
                            bytesRead += (long)read;
                            os.write(buffer, 0, read);
                            read = is.read(buffer);
                        }
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                        if (os != null) {
                            os.close();
                        }
                    }
                    long elapsedDownload = System.nanoTime() - startDownload;
                    this.elapsedSeconds = (float)(1L + elapsedDownload) / 1.0E9f;
                    this.kbRead = (float)bytesRead / 1024.0f;
                } else {
                    if (responseCode == 4) {
                        throw new IllegalStateException("Remote file not found: " + this.url_str);
                    }
                    if (!this.work) {
                        System.out.println("Try downloading " + this.url_str + " again.");
                        this.work = true;
                    } else {
                        throw new IllegalStateException("HTTP Response Code " + ((HttpURLConnection)conn).getResponseCode());
                    }
                }
                ((HttpURLConnection)conn).disconnect();
                if ((long)this.expectedDownloadSize == this.targetFile.length() || this.expectedDownloadSize == -1) {
                    this.work = false;
                    continue;
                }
                System.out.println("Size different " + this.url_str + ": " + this.expectedDownloadSize + " vs " + this.targetFile.length());
            }
            catch (IOException | KeyManagementException | NoSuchAlgorithmException ioe) {
                if (!this.work) {
                    System.out.println("Try downloading " + this.url_str + " again.");
                    this.work = true;
                    continue;
                }
                throw new IllegalStateException(ioe);
            }
        } while (this.work);
    }

    public int getExpectedDownloadSize() {
        return this.expectedDownloadSize;
    }

    public boolean isDownloadSizeEqual() throws IOException {
        int groe = this.getDownloadSize();
        int ist = (int)this.targetFile.length();
        boolean identisch = true;
        if (groe != ist) {
            identisch = false;
        }
        return identisch;
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public float getKbRead() {
        return this.kbRead;
    }

    public float getElapsedSeconds() {
        return this.elapsedSeconds;
    }

    public int getDownloadSize() throws IOException {
        URL url = new URL(this.url_str.replace(" ", "%20"));
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setUseCaches(false);
        conn.setDefaultUseCaches(false);
        conn.setRequestProperty("Cache-Control", "no-store,max-age=0,no-cache");
        conn.setRequestProperty("Expires", "0");
        conn.setRequestProperty("Pragma", "no-cache");
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(10000);
        this.expectedDownloadSize = conn.getContentLength();
        conn.disconnect();
        return this.expectedDownloadSize;
    }

    public File getTargetFile() {
        return this.targetFile;
    }
}

