/*
 * Decompiled with CFR 0.152.
 */
package org.spout.nbt.holder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.spout.nbt.CompoundMap;
import org.spout.nbt.CompoundTag;
import org.spout.nbt.Tag;
import org.spout.nbt.holder.FieldValue;
import org.spout.nbt.stream.NBTInputStream;
import org.spout.nbt.stream.NBTOutputStream;

public abstract class FieldHolder {
    private final List<FieldValue<?>> fields = new ArrayList();
    private NBTOutputStream os;
    private NBTInputStream is;

    protected FieldHolder(FieldValue<?> ... fields) {
        this.addFields(fields);
    }

    protected void addFields(FieldValue<?> ... fields) {
        Collections.addAll(this.fields, fields);
    }

    public CompoundMap save() {
        CompoundMap map = new CompoundMap();
        for (FieldValue<?> field : this.fields) {
            field.save(map);
        }
        return map;
    }

    public void load(CompoundTag tag) {
        for (FieldValue<?> field : this.fields) {
            field.load(tag);
        }
    }

    public void save(File file, boolean compressed) throws IOException {
        this.save(new FileOutputStream(file), compressed);
    }

    public void save(OutputStream stream, boolean compressed) throws IOException {
        this.os = new NBTOutputStream(stream, compressed);
        this.os.writeTag(new CompoundTag("", this.save()));
    }

    public void load(File file, boolean compressed) throws IOException {
        this.load(new FileInputStream(file), compressed);
    }

    public void load(InputStream stream, boolean compressed) throws IOException {
        this.is = new NBTInputStream(stream, compressed);
        Tag tag = this.is.readTag();
        if (!(tag instanceof CompoundTag)) {
            throw new IllegalArgumentException("Expected CompoundTag, got " + tag.getClass());
        }
        CompoundTag compound = (CompoundTag)tag;
        this.load(compound);
    }
}

